/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.item;

import java.util.function.Function;
import java.util.function.Supplier;
import li.cil.oc2.common.block.Blocks;
import li.cil.oc2.common.bus.device.data.BlockDeviceDataRegistration;
import li.cil.oc2.common.bus.device.data.Firmwares;
import li.cil.oc2.common.item.BlockOperationsModule;
import li.cil.oc2.common.item.BusCableItem;
import li.cil.oc2.common.item.BusInterfaceItem;
import li.cil.oc2.common.item.ChargerItem;
import li.cil.oc2.common.item.FlashMemoryItem;
import li.cil.oc2.common.item.FlashMemoryWithExternalDataItem;
import li.cil.oc2.common.item.FloppyItem;
import li.cil.oc2.common.item.HardDriveItem;
import li.cil.oc2.common.item.HardDriveWithExternalDataItem;
import li.cil.oc2.common.item.ManualItem;
import li.cil.oc2.common.item.MemoryItem;
import li.cil.oc2.common.item.ModBlockItem;
import li.cil.oc2.common.item.ModItem;
import li.cil.oc2.common.item.NetworkCableItem;
import li.cil.oc2.common.item.NetworkInterfaceCardItem;
import li.cil.oc2.common.item.NetworkTunnelItem;
import li.cil.oc2.common.item.RobotItem;
import li.cil.oc2.common.item.WrenchItem;
import li.cil.oc2.common.util.RegistryUtils;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public final class Items {
    private static final DeferredRegister<Item> ITEMS = RegistryUtils.create(ForgeRegistries.ITEMS);
    public static final RegistryObject<Item> BUS_CABLE = Items.register(Blocks.BUS_CABLE, BusCableItem::new);
    public static final RegistryObject<BusInterfaceItem> BUS_INTERFACE = Items.register("bus_interface", BusInterfaceItem::new);
    public static final RegistryObject<Item> CHARGER = Items.register(Blocks.CHARGER, ChargerItem::new);
    public static final RegistryObject<Item> COMPUTER = Items.register(Blocks.COMPUTER);
    public static final RegistryObject<Item> CREATIVE_ENERGY = Items.register(Blocks.CREATIVE_ENERGY);
    public static final RegistryObject<Item> DISK_DRIVE = Items.register(Blocks.DISK_DRIVE);
    public static final RegistryObject<Item> NETWORK_CONNECTOR = Items.register(Blocks.NETWORK_CONNECTOR);
    public static final RegistryObject<Item> NETWORK_HUB = Items.register(Blocks.NETWORK_HUB);
    public static final RegistryObject<Item> REDSTONE_INTERFACE = Items.register(Blocks.REDSTONE_INTERFACE);
    public static final RegistryObject<Item> WRENCH = Items.register("wrench", WrenchItem::new);
    public static final RegistryObject<Item> MANUAL = Items.register("manual", ManualItem::new);
    public static final RegistryObject<Item> ROBOT = Items.register("robot", RobotItem::new);
    public static final RegistryObject<NetworkCableItem> NETWORK_CABLE = Items.register("network_cable", NetworkCableItem::new);
    public static final RegistryObject<MemoryItem> MEMORY_SMALL = Items.register("memory_small", () -> new MemoryItem(0x200000));
    public static final RegistryObject<MemoryItem> MEMORY_MEDIUM = Items.register("memory_medium", () -> new MemoryItem(0x400000));
    public static final RegistryObject<MemoryItem> MEMORY_LARGE = Items.register("memory_large", () -> new MemoryItem(0x800000));
    public static final RegistryObject<HardDriveItem> HARD_DRIVE_SMALL = Items.register("hard_drive_small", () -> new HardDriveItem(0x200000, DyeColor.LIGHT_GRAY));
    public static final RegistryObject<HardDriveItem> HARD_DRIVE_MEDIUM = Items.register("hard_drive_medium", () -> new HardDriveItem(0x400000, DyeColor.GREEN));
    public static final RegistryObject<HardDriveItem> HARD_DRIVE_LARGE = Items.register("hard_drive_large", () -> new HardDriveItem(0x800000, DyeColor.CYAN));
    public static final RegistryObject<HardDriveWithExternalDataItem> HARD_DRIVE_CUSTOM = Items.register("hard_drive_buildroot", () -> new HardDriveWithExternalDataItem(BlockDeviceDataRegistration.BUILDROOT.getId(), DyeColor.BROWN));
    public static final RegistryObject<FlashMemoryItem> FLASH_MEMORY = Items.register("flash_memory", () -> new FlashMemoryItem(4096));
    public static final RegistryObject<FlashMemoryWithExternalDataItem> FLASH_MEMORY_CUSTOM = Items.register("flash_memory_buildroot", () -> new FlashMemoryWithExternalDataItem(Firmwares.BUILDROOT.getId()));
    public static final RegistryObject<FloppyItem> FLOPPY = Items.register("floppy", () -> new FloppyItem(524288));
    public static final RegistryObject<Item> REDSTONE_INTERFACE_CARD = Items.register("redstone_interface_card");
    public static final RegistryObject<Item> NETWORK_INTERFACE_CARD = Items.register("network_interface_card", NetworkInterfaceCardItem::new);
    public static final RegistryObject<Item> NETWORK_TUNNEL_CARD = Items.register("network_tunnel_card", NetworkTunnelItem::new);
    public static final RegistryObject<Item> FILE_IMPORT_EXPORT_CARD = Items.register("file_import_export_card");
    public static final RegistryObject<Item> SOUND_CARD = Items.register("sound_card");
    public static final RegistryObject<Item> INVENTORY_OPERATIONS_MODULE = Items.register("inventory_operations_module");
    public static final RegistryObject<Item> BLOCK_OPERATIONS_MODULE = Items.register("block_operations_module", BlockOperationsModule::new);
    public static final RegistryObject<Item> NETWORK_TUNNEL_MODULE = Items.register("network_tunnel_module", NetworkTunnelItem::new);
    public static final RegistryObject<Item> TRANSISTOR = Items.register("transistor", ModItem::new);
    public static final RegistryObject<Item> CIRCUIT_BOARD = Items.register("circuit_board", ModItem::new);

    public static void initialize() {
    }

    private static RegistryObject<Item> register(String name) {
        return Items.register(name, ModItem::new);
    }

    private static <T extends Item> RegistryObject<T> register(String name, Supplier<T> factory) {
        return ITEMS.register(name, factory);
    }

    private static <T extends Block> RegistryObject<Item> register(RegistryObject<T> block) {
        return Items.register(block, ModBlockItem::new);
    }

    private static <TBlock extends Block, TItem extends Item> RegistryObject<TItem> register(RegistryObject<TBlock> block, Function<TBlock, TItem> factory) {
        return Items.register(block.getId().m_135815_(), () -> (Item)factory.apply((Block)block.get()));
    }
}

