/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.container;

import java.util.UUID;
import li.cil.oc2.api.bus.device.DeviceTypes;
import li.cil.oc2.common.container.AbstractContainer;
import li.cil.oc2.common.container.Containers;
import li.cil.oc2.common.container.DeviceTypeSlot;
import li.cil.oc2.common.container.LockedSlot;
import li.cil.oc2.common.item.NetworkTunnelItem;
import li.cil.oc2.common.tags.ItemTags;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkHooks;

public final class NetworkTunnelContainer
extends AbstractContainer {
    private final Player player;
    private final InteractionHand hand;
    private final Container linkSlot = new SimpleContainer(1);

    public static void createServer(final ServerPlayer player, final InteractionHand hand) {
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return player.m_21120_(hand).m_41720_().m_41466_();
            }

            public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player2) {
                return new NetworkTunnelContainer(id, player2, hand);
            }
        }, b -> b.m_130068_((Enum)hand));
    }

    public static NetworkTunnelContainer createClient(int id, Inventory inventory, FriendlyByteBuf data) {
        InteractionHand hand = (InteractionHand)data.m_130066_(InteractionHand.class);
        Player player = inventory.f_35978_;
        return new NetworkTunnelContainer(id, player, hand);
    }

    private NetworkTunnelContainer(int id, Player player, InteractionHand hand) {
        super((MenuType)Containers.NETWORK_TUNNEL.get(), id);
        this.player = player;
        this.hand = hand;
        this.createPlayerInventoryAndHotbarSlots(player.m_150109_(), 8, 115);
        this.m_38897_(new LockedSlot((Container)player.m_150109_(), this.getHandSlot(), 80, 25));
        this.m_38897_(new DeviceTypeSlot(this.linkSlot, DeviceTypes.NETWORK_TUNNEL, 0, 80, 51));
    }

    public boolean hasLinkSlotItem() {
        return !this.linkSlot.m_8020_(0).m_41619_();
    }

    public void createTunnel() {
        ItemStack tunnelA = this.player.m_21120_(this.hand);
        ItemStack tunnelB = this.linkSlot.m_8020_(0);
        if (tunnelA.m_41619_() || tunnelB.m_41619_() || !tunnelA.m_150922_(ItemTags.DEVICES_NETWORK_TUNNEL) || !tunnelB.m_150922_(ItemTags.DEVICES_NETWORK_TUNNEL)) {
            return;
        }
        UUID id = UUID.randomUUID();
        NetworkTunnelItem.setTunnelId(tunnelA, id);
        NetworkTunnelItem.setTunnelId(tunnelB, id);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (!player.m_183503_().m_5776_()) {
            this.m_150411_(player, this.linkSlot);
        }
    }

    public boolean m_6875_(Player player) {
        return player.m_21120_(this.hand).m_150922_(ItemTags.DEVICES_NETWORK_TUNNEL);
    }

    @Override
    protected boolean isSlotLocked(Inventory inventory, int slot) {
        return inventory.m_8020_(slot) == this.player.m_21120_(this.hand);
    }

    private int getHandSlot() {
        Inventory inventory = this.player.m_150109_();
        for (int slot = 0; slot < inventory.m_6643_(); ++slot) {
            if (inventory.m_8020_(slot) != this.player.m_21120_(this.hand)) continue;
            return slot;
        }
        return -1;
    }
}

