/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.container;

import java.nio.ByteBuffer;
import li.cil.oc2.common.block.Blocks;
import li.cil.oc2.common.blockentity.ComputerBlockEntity;
import li.cil.oc2.common.bus.CommonDeviceBusController;
import li.cil.oc2.common.container.AbstractMachineTerminalContainer;
import li.cil.oc2.common.container.IntPrecisionContainerData;
import li.cil.oc2.common.network.Network;
import li.cil.oc2.common.network.message.ComputerPowerMessage;
import li.cil.oc2.common.network.message.ComputerTerminalInputMessage;
import li.cil.oc2.common.network.message.OpenComputerInventoryMessage;
import li.cil.oc2.common.network.message.OpenComputerTerminalMessage;
import li.cil.oc2.common.vm.Terminal;
import li.cil.oc2.common.vm.VirtualMachine;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class AbstractComputerContainer
extends AbstractMachineTerminalContainer {
    private final ComputerBlockEntity computer;

    protected AbstractComputerContainer(MenuType<?> type, int id, Player player, ComputerBlockEntity computer, IntPrecisionContainerData energyInfo) {
        super(type, id, energyInfo);
        this.computer = computer;
        this.computer.addTerminalUser(player);
    }

    @Override
    public void switchToInventory() {
        Network.sendToServer(new OpenComputerInventoryMessage(this.computer));
    }

    @Override
    public void switchToTerminal() {
        Network.sendToServer(new OpenComputerTerminalMessage(this.computer));
    }

    @Override
    public VirtualMachine getVirtualMachine() {
        return this.computer.getVirtualMachine();
    }

    @Override
    public void sendPowerStateToServer(boolean value) {
        Network.sendToServer(new ComputerPowerMessage(this.computer, value));
    }

    @Override
    public Terminal getTerminal() {
        return this.computer.getTerminal();
    }

    @Override
    public void sendTerminalInputToServer(ByteBuffer input) {
        Network.sendToServer(new ComputerTerminalInputMessage(this.computer, input));
    }

    public boolean m_6875_(Player player) {
        if (this.computer.m_58901_()) {
            return false;
        }
        Level level = this.computer.m_58904_();
        return level != null && AbstractComputerContainer.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)level, (BlockPos)this.computer.m_58899_()), (Player)player, (Block)((Block)Blocks.COMPUTER.get()));
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.computer.removeTerminalUser(player);
    }

    protected static IntPrecisionContainerData createEnergyInfo(final IEnergyStorage energy, final CommonDeviceBusController busController) {
        return new IntPrecisionContainerData.Server(){

            @Override
            public int getInt(int index) {
                return switch (index) {
                    case 0 -> energy.getEnergyStored();
                    case 1 -> energy.getMaxEnergyStored();
                    case 2 -> busController.getEnergyConsumption();
                    default -> 0;
                };
            }

            @Override
            public int getIntCount() {
                return 3;
            }
        };
    }
}

