/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.rpc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import li.cil.oc2.api.bus.device.rpc.RPCDevice;
import li.cil.oc2.api.bus.device.rpc.RPCMethodGroup;
import net.minecraft.nbt.CompoundTag;

public record RPCDeviceList(ArrayList<RPCDevice> devices) implements RPCDevice
{
    @Override
    public List<String> getTypeNames() {
        return this.devices.stream().map(RPCDevice::getTypeNames).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    @Override
    public List<RPCMethodGroup> getMethodGroups() {
        return this.devices.stream().map(RPCDevice::getMethodGroups).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public void mount() {
        for (RPCDevice device : this.devices) {
            device.mount();
        }
    }

    @Override
    public void unmount() {
        for (RPCDevice device : this.devices) {
            device.unmount();
        }
    }

    @Override
    public void dispose() {
        for (RPCDevice device : this.devices) {
            device.dispose();
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        throw new UnsupportedOperationException();
    }
}

