/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.item;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.object.Callback;
import li.cil.oc2.api.bus.device.object.Parameter;
import li.cil.oc2.common.bus.device.item.AbstractItemRPCDevice;
import li.cil.oc2.common.util.Location;
import li.cil.oc2.common.util.TickUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.registries.ForgeRegistries;

public final class SoundCardItemDevice
extends AbstractItemRPCDevice {
    private static final int COOLDOWN_IN_TICKS = TickUtils.toTicks(Duration.ofSeconds(2L));
    private static final int MAX_FIND_RESULTS = 25;
    private final Supplier<Optional<Location>> location;
    private long gameTimeCooldownExpiresAt;

    public SoundCardItemDevice(ItemStack identity, Supplier<Optional<Location>> location) {
        super(identity, "sound");
        this.location = location;
    }

    @Callback
    public void playSound(@Nullable @Parameter(value="name") String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.location.get().ifPresent(location -> {
            LevelAccessor level = location.level();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            long gameTime = serverLevel.m_46467_();
            if (gameTime < this.gameTimeCooldownExpiresAt) {
                return;
            }
            this.gameTimeCooldownExpiresAt = gameTime + (long)COOLDOWN_IN_TICKS;
            SoundEvent soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(name));
            if (soundEvent == null) {
                throw new IllegalArgumentException("Sound not found.");
            }
            level.m_5594_(null, location.pos(), soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        });
    }

    @Callback
    public List<String> findSound(@Nullable @Parameter(value="name") String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> matches = new ArrayList<String>();
        for (ResourceLocation key : ForgeRegistries.SOUND_EVENTS.getKeys()) {
            String keyName = key.toString();
            if (!keyName.contains(name)) continue;
            matches.add(keyName);
            if (matches.size() < 25) continue;
            break;
        }
        return matches;
    }
}

