/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.item;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import li.cil.oc2.common.bus.device.item.HardDriveVMDevice;
import li.cil.oc2.common.util.Location;
import li.cil.sedna.api.device.BlockDevice;
import li.cil.sedna.device.block.ByteBufferBlockDevice;
import net.minecraft.world.item.ItemStack;

public final class HardDriveVMDeviceWithInitialData
extends HardDriveVMDevice {
    private final BlockDevice base;

    public HardDriveVMDeviceWithInitialData(ItemStack identity, BlockDevice base, boolean readonly, Supplier<Optional<Location>> location) {
        super(identity, (int)base.getCapacity(), readonly, location);
        this.base = base;
    }

    @Override
    protected CompletableFuture<ByteBufferBlockDevice> createBlockDevice() {
        boolean isInitializing = this.blobHandle == null;
        return super.createBlockDevice().thenApplyAsync(device -> {
            if (isInitializing) {
                try (InputStream input = this.base.getInputStream(0L);
                     OutputStream output = device.getOutputStream(0L);){
                    ByteStreams.copy((InputStream)input, (OutputStream)output);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return device;
        }, (Executor)WORKERS);
    }
}

