/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.data;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import li.cil.oc2.common.vm.fs.LayeredFileSystem;
import li.cil.sedna.fs.FileSystem;
import li.cil.sedna.fs.ZipStreamFileSystem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FileSystems {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final LayeredFileSystem LAYERED_FILE_SYSTEM = new LayeredFileSystem();

    public static void initialize() {
        MinecraftForge.EVENT_BUS.addListener(FileSystems::handleAddReloadListenerEvent);
    }

    public static FileSystem getLayeredFileSystem() {
        return LAYERED_FILE_SYSTEM;
    }

    public static void reset() {
        LAYERED_FILE_SYSTEM.clear();
    }

    private static void handleAddReloadListenerEvent(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)ReloadListener.INSTANCE);
    }

    private static void reload(ResourceManager resourceManager) {
        FileSystems.reset();
        LOGGER.info("Searching for datapack filesystems...");
        Collection fileSystemDescriptorLocations = resourceManager.m_6540_("file_systems", s -> s.endsWith(".json"));
        ArrayList<ZipStreamFileSystem> fileSystems = new ArrayList<ZipStreamFileSystem>();
        Object2IntArrayMap fileSystemOrder = new Object2IntArrayMap();
        for (ResourceLocation fileSystemDescriptorLocation : fileSystemDescriptorLocations) {
            LOGGER.info("Found [{}]", (Object)fileSystemDescriptorLocation);
            try {
                String type;
                Resource fileSystemDescriptor = resourceManager.m_142591_(fileSystemDescriptorLocation);
                JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(fileSystemDescriptor.m_6679_())).getAsJsonObject();
                switch (type = json.getAsJsonPrimitive("type").getAsString()) {
                    case "layer": {
                        ZipStreamFileSystem fileSystem;
                        ResourceLocation location = new ResourceLocation(json.getAsJsonPrimitive("location").getAsString());
                        try (InputStream stream = resourceManager.m_142591_(location).m_6679_();){
                            fileSystem = new ZipStreamFileSystem(stream);
                        }
                        long fileCount = fileSystem.statfs().fileCount;
                        if (fileCount > 0L) {
                            LOGGER.info("  Adding layer with [{}] file(s).", (Object)fileCount);
                            fileSystems.add(fileSystem);
                        } else {
                            LOGGER.info("  Skipping empty layer.");
                        }
                        if (json.has("order")) {
                            JsonPrimitive order = json.getAsJsonPrimitive("order");
                            fileSystemOrder.put((Object)fileSystem, order.getAsInt());
                            break;
                        }
                        fileSystemOrder.put((Object)fileSystem, 0);
                        break;
                    }
                    case "block": {
                        LOGGER.error("Not yet implemented.");
                        break;
                    }
                    default: {
                        LOGGER.error("Unsupported file system type [{}].", (Object)type);
                    }
                }
            }
            catch (Throwable e) {
                LOGGER.error((Object)e);
            }
        }
        fileSystems.sort(Comparator.comparingInt(arg_0 -> ((Object2IntArrayMap)fileSystemOrder).getInt(arg_0)));
        fileSystems.forEach(LAYERED_FILE_SYSTEM::addLayer);
    }

    private static final class ReloadListener
    implements PreparableReloadListener {
        public static final ReloadListener INSTANCE = new ReloadListener();

        private ReloadListener() {
        }

        public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            return CompletableFuture.runAsync(() -> FileSystems.reload(resourceManager), backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0));
        }
    }
}

