/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.blockentity;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import li.cil.oc2.api.capabilities.NetworkInterface;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.blockentity.BlockEntities;
import li.cil.oc2.common.blockentity.ModBlockEntity;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.util.LazyOptionalUtils;
import li.cil.oc2.common.util.LevelUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;

public final class NetworkHubBlockEntity
extends ModBlockEntity
implements NetworkInterface {
    private static final int TTL_COST = 1;
    private final NetworkInterface[] adjacentBlockInterfaces = new NetworkInterface[Constants.BLOCK_FACE_COUNT];
    private boolean haveAdjacentBlocksChanged = true;

    public NetworkHubBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntities.NETWORK_HUB.get(), pos, state);
    }

    public void handleNeighborChanged() {
        this.haveAdjacentBlocksChanged = true;
    }

    @Override
    public byte[] readEthernetFrame() {
        return null;
    }

    @Override
    public void writeEthernetFrame(NetworkInterface source, byte[] frame, int timeToLive) {
        this.getAdjacentInterfaces().forEach(adjacentInterface -> {
            if (adjacentInterface != source) {
                adjacentInterface.writeEthernetFrame(this, frame, timeToLive - 1);
            }
        });
    }

    @Override
    protected void collectCapabilities(ModBlockEntity.CapabilityCollector collector, @Nullable Direction direction) {
        collector.offer(Capabilities.NETWORK_INTERFACE, this);
    }

    private Stream<NetworkInterface> getAdjacentInterfaces() {
        this.validateAdjacentBlocks();
        return Arrays.stream(this.adjacentBlockInterfaces).filter(Objects::nonNull);
    }

    private void validateAdjacentBlocks() {
        if (this.m_58901_() || !this.haveAdjacentBlocksChanged) {
            return;
        }
        for (Direction side : Constants.DIRECTIONS) {
            this.adjacentBlockInterfaces[side.m_122411_()] = null;
        }
        this.haveAdjacentBlocksChanged = false;
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        BlockPos pos = this.m_58899_();
        for (Direction side : Constants.DIRECTIONS) {
            BlockEntity neighborBlockEntity = LevelUtils.getBlockEntityIfChunkExists((LevelAccessor)this.f_58857_, pos.m_142300_(side));
            if (neighborBlockEntity == null) continue;
            LazyOptional optional = neighborBlockEntity.getCapability(Capabilities.NETWORK_INTERFACE, side.m_122424_());
            optional.ifPresent(adjacentInterface -> {
                this.adjacentBlockInterfaces[side.m_122411_()] = adjacentInterface;
                LazyOptionalUtils.addWeakListener(optional, this, (hub, unused) -> hub.handleNeighborChanged());
            });
        }
    }
}

