/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.blockentity;

import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nullable;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.block.BusCableBlock;
import li.cil.oc2.common.blockentity.BlockEntities;
import li.cil.oc2.common.blockentity.ModBlockEntity;
import li.cil.oc2.common.bus.BlockEntityDeviceBusElement;
import li.cil.oc2.common.bus.device.rpc.TypeNameRPCDevice;
import li.cil.oc2.common.bus.device.util.BlockDeviceInfo;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.network.Network;
import li.cil.oc2.common.network.message.BusCableFacadeMessage;
import li.cil.oc2.common.network.message.BusInterfaceNameMessage;
import li.cil.oc2.common.util.ItemStackUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public final class BusCableBlockEntity
extends ModBlockEntity {
    private static final String BUS_ELEMENT_TAG_NAME = "busElement";
    private static final String INTERFACE_NAMES_TAG_NAME = "interfaceNames";
    private static final String FACADE_TAG_NAME = "facade";
    private final BlockEntityDeviceBusElement busElement = new BusCableBusElement();
    private final String[] interfaceNames = new String[Constants.BLOCK_FACE_COUNT];
    private ItemStack facade = ItemStack.f_41583_;

    public BusCableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntities.BUS_CABLE.get(), pos, state);
    }

    public String getInterfaceName(Direction side) {
        String interfaceName = this.interfaceNames[side.m_122411_()];
        return interfaceName == null ? "" : interfaceName;
    }

    public void setInterfaceName(Direction side, String name) {
        if (this.f_58857_ == null) {
            return;
        }
        String validatedName = BusCableBlockEntity.validateName(name);
        if (Objects.equals(validatedName, this.interfaceNames[side.m_122411_()])) {
            return;
        }
        this.interfaceNames[side.m_122411_()] = validatedName;
        this.m_6596_();
        if (!this.f_58857_.m_5776_()) {
            BusInterfaceNameMessage.ToClient message = new BusInterfaceNameMessage.ToClient(this, side, this.interfaceNames[side.m_122411_()]);
            Network.sendToClientsTrackingBlockEntity(message, this);
            this.handleNeighborChanged(this.m_58899_().m_142300_(side));
        }
    }

    public FacadeType getFacadeType(ItemStack stack) {
        return this.getFacadeType(ItemStackUtils.getBlockState(stack));
    }

    public FacadeType getFacadeType(@Nullable BlockState state) {
        if (state == null) {
            return FacadeType.NOT_A_BLOCK;
        }
        if (this.f_58857_ == null || state.m_60799_() != RenderShape.MODEL || !state.m_60804_((BlockGetter)this.f_58857_, this.m_58899_()) || state.m_60734_() instanceof EntityBlock) {
            return FacadeType.INVALID_BLOCK;
        }
        return FacadeType.VALID_BLOCK;
    }

    public ItemStack getFacade() {
        return this.facade;
    }

    public void setFacade(ItemStack stack) {
        if (this.f_58857_ == null) {
            return;
        }
        BlockState facadeState = ItemStackUtils.getBlockState(stack);
        if (this.getFacadeType(facadeState) != FacadeType.VALID_BLOCK) {
            stack = ItemStack.f_41583_;
        }
        if (ItemStack.m_41746_((ItemStack)stack, (ItemStack)this.facade)) {
            return;
        }
        this.facade = stack.m_41777_();
        this.facade.m_41764_(1);
        BusCableBlock.setHasFacade(this.f_58857_, this.m_58899_(), this.m_58900_(), facadeState, true);
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        if (!this.f_58857_.m_5776_()) {
            BusCableFacadeMessage message = new BusCableFacadeMessage(this.m_58899_(), this.facade);
            Network.sendToClientsTrackingBlockEntity(message, this);
        }
    }

    public void removeFacade() {
        if (this.f_58857_ == null) {
            return;
        }
        BlockState facadeState = ItemStackUtils.getBlockState(this.facade);
        this.facade = ItemStack.f_41583_;
        BusCableBlock.setHasFacade(this.f_58857_, this.m_58899_(), this.m_58900_(), facadeState, false);
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        if (!this.f_58857_.m_5776_()) {
            BusCableFacadeMessage message = new BusCableFacadeMessage(this.m_58899_(), this.facade);
            Network.sendToClientsTrackingBlockEntity(message, this);
        }
    }

    public void handleNeighborChanged(BlockPos pos) {
        this.busElement.handleNeighborChanged(pos);
    }

    public void handleConnectivityChanged(@Nullable Direction side, boolean neighborConnectionChanged) {
        if (side == null) {
            this.busElement.scheduleScan();
        } else {
            this.setInterfaceName(side, "");
            this.invalidateCapability(Capabilities.DEVICE_BUS_ELEMENT, side);
            this.handleNeighborChanged(this.m_58899_().m_142300_(side));
            if (neighborConnectionChanged) {
                this.busElement.scheduleScan();
            }
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128365_(INTERFACE_NAMES_TAG_NAME, (Tag)this.serializeInterfaceNames());
        tag.m_128365_(FACADE_TAG_NAME, (Tag)this.facade.serializeNBT());
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.deserializeInterfaceNames(tag.m_128437_(INTERFACE_NAMES_TAG_NAME, 8));
        this.setFacade(ItemStack.m_41712_((CompoundTag)tag.m_128469_(FACADE_TAG_NAME)));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(BUS_ELEMENT_TAG_NAME, (Tag)this.busElement.save());
        tag.m_128365_(INTERFACE_NAMES_TAG_NAME, (Tag)this.serializeInterfaceNames());
        tag.m_128365_(FACADE_TAG_NAME, (Tag)this.facade.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.busElement.load(tag.m_128469_(BUS_ELEMENT_TAG_NAME));
        this.deserializeInterfaceNames(tag.m_128437_(INTERFACE_NAMES_TAG_NAME, 8));
        this.facade = ItemStack.m_41712_((CompoundTag)tag.m_128469_(FACADE_TAG_NAME));
    }

    @Override
    protected void collectCapabilities(ModBlockEntity.CapabilityCollector collector, @Nullable Direction direction) {
        if (BusCableBlock.getConnectionType(this.m_58900_(), direction) != BusCableBlock.ConnectionType.NONE) {
            collector.offer(Capabilities.DEVICE_BUS_ELEMENT, this.busElement);
        }
    }

    @Override
    protected void loadServer() {
        super.loadServer();
        this.busElement.initialize();
    }

    @Override
    protected void unloadServer(boolean isRemove) {
        super.unloadServer(isRemove);
        if (isRemove) {
            this.busElement.scheduleScan();
        }
    }

    private ListTag serializeInterfaceNames() {
        ListTag tag = new ListTag();
        for (int i = 0; i < Constants.BLOCK_FACE_COUNT; ++i) {
            tag.add((Object)StringTag.m_129297_((String)this.getInterfaceName(Direction.m_122376_((int)i))));
        }
        return tag;
    }

    private void deserializeInterfaceNames(ListTag tag) {
        for (int i = 0; i < Constants.BLOCK_FACE_COUNT; ++i) {
            String name = tag.m_128778_(i).trim();
            this.interfaceNames[i] = name.substring(0, Math.min(32, name.length()));
        }
    }

    private static String validateName(String name) {
        String trimmed = name.trim();
        return trimmed.length() > 32 ? trimmed.substring(0, 32) : trimmed;
    }

    private final class BusCableBusElement
    extends BlockEntityDeviceBusElement {
        public BusCableBusElement() {
            super(BusCableBlockEntity.this);
        }

        @Override
        public boolean canScanContinueTowards(@Nullable Direction direction) {
            BusCableBlock.ConnectionType connectionType = BusCableBlock.getConnectionType(BusCableBlockEntity.this.m_58900_(), direction);
            return connectionType == BusCableBlock.ConnectionType.CABLE || connectionType == BusCableBlock.ConnectionType.INTERFACE;
        }

        @Override
        public boolean canDetectDevicesTowards(@Nullable Direction direction) {
            BusCableBlock.ConnectionType connectionType = BusCableBlock.getConnectionType(BusCableBlockEntity.this.m_58900_(), direction);
            return connectionType == BusCableBlock.ConnectionType.INTERFACE;
        }

        @Override
        protected void collectSyntheticDevices(Level level, BlockPos pos, @Nullable Direction direction, HashSet<BlockEntityDeviceBusElement.BlockEntry> entries) {
            String interfaceName;
            super.collectSyntheticDevices(level, pos, direction, entries);
            if (direction != null && !StringUtil.m_14408_((String)(interfaceName = BusCableBlockEntity.this.interfaceNames[direction.m_122411_()]))) {
                entries.add(new BlockEntityDeviceBusElement.BlockEntry((BlockEntityDeviceBusElement)this, new BlockDeviceInfo(null, new TypeNameRPCDevice(interfaceName)), pos));
            }
        }

        @Override
        public double getEnergyConsumption() {
            return super.getEnergyConsumption() + Config.busCableEnergyPerTick + (double)BusCableBlock.getInterfaceCount(BusCableBlockEntity.this.m_58900_()) * Config.busInterfaceEnergyPerTick;
        }
    }

    public static enum FacadeType {
        NOT_A_BLOCK,
        INVALID_BLOCK,
        VALID_BLOCK;

    }
}

