/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="oc2", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ConfigManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<Class<?>, ConfigFieldParser> PARSERS = new HashMap();
    private static final Map<IConfigSpec<ForgeConfigSpec>, ConfigDefinition> CONFIGS = new HashMap<IConfigSpec<ForgeConfigSpec>, ConfigDefinition>();

    public static <T> void add(Supplier<T> factory) {
        ArrayList values = new ArrayList();
        Pair config = new ForgeConfigSpec.Builder().configure(builder -> {
            Object instance = factory.get();
            ConfigManager.fillSpec(instance, builder, values);
            return instance;
        });
        CONFIGS.put((IConfigSpec<ForgeConfigSpec>)((IConfigSpec)config.getValue()), new ConfigDefinition(config.getKey(), values));
    }

    public static void initialize() {
        CONFIGS.forEach((spec, config) -> {
            Type typeAnnotation = config.instance.getClass().getAnnotation(Type.class);
            ModConfig.Type configType = typeAnnotation != null ? typeAnnotation.value() : ModConfig.Type.COMMON;
            ModLoadingContext.get().registerConfig(configType, spec);
        });
    }

    @SubscribeEvent
    public static void handleModConfigEvent(ModConfigEvent event) {
        ConfigDefinition config = CONFIGS.get(event.getConfig().getSpec());
        if (config != null) {
            config.apply();
        }
    }

    private static <T> void fillSpec(T instance, ForgeConfigSpec.Builder builder, ArrayList<ConfigFieldPair<?>> values) {
        for (Field field : instance.getClass().getFields()) {
            ConfigManager.parseField(instance, builder, values, field);
        }
    }

    private static <T> void parseField(T instance, ForgeConfigSpec.Builder builder, ArrayList<ConfigFieldPair<?>> values, Field field) {
        ConfigFieldParser parser = PARSERS.get(field.getType());
        if (parser != null) {
            Path pathAnnotation = field.getAnnotation(Path.class);
            String path = ConfigManager.getPath(pathAnnotation.value(), field);
            try {
                values.add(parser.apply(instance, field, path, builder));
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Failed accessing field [{}.{}], ignoring.", (Object)field.getDeclaringClass().getName(), (Object)field.getName());
            }
        }
    }

    private static ConfigFieldPair<?> parseIntField(Object instance, Field field, String path, ForgeConfigSpec.Builder builder) throws IllegalAccessException {
        int defaultValue = field.getInt(instance);
        int minValue = (int)Math.max(ConfigManager.getMin(field), -2.147483648E9);
        int maxValue = (int)Math.min(ConfigManager.getMax(field), 2.147483647E9);
        ForgeConfigSpec.IntValue configValue = builder.defineInRange(path, defaultValue, minValue, maxValue);
        return new ConfigFieldPair(field, configValue);
    }

    private static ConfigFieldPair<?> parseLongField(Object instance, Field field, String path, ForgeConfigSpec.Builder builder) throws IllegalAccessException {
        long defaultValue = field.getLong(instance);
        long minValue = (long)Math.max(ConfigManager.getMin(field), -9.223372036854776E18);
        long maxValue = (long)Math.min(ConfigManager.getMax(field), 9.223372036854776E18);
        ForgeConfigSpec.LongValue configValue = builder.defineInRange(path, defaultValue, minValue, maxValue);
        return new ConfigFieldPair(field, configValue);
    }

    private static ConfigFieldPair<?> parseDoubleField(Object instance, Field field, String path, ForgeConfigSpec.Builder builder) throws IllegalAccessException {
        double defaultValue = field.getDouble(instance);
        double minValue = ConfigManager.getMin(field);
        double maxValue = ConfigManager.getMax(field);
        ForgeConfigSpec.DoubleValue configValue = builder.defineInRange(path, defaultValue, minValue, maxValue);
        return new ConfigFieldPair(field, configValue);
    }

    private static ConfigFieldPair<?> parseStringField(Object instance, Field field, String path, ForgeConfigSpec.Builder builder) throws IllegalAccessException {
        String defaultValue = (String)field.get(instance);
        ForgeConfigSpec.ConfigValue configValue = builder.define(path, (Object)defaultValue);
        return new ConfigFieldPair(field, configValue);
    }

    private static ConfigFieldPair<?> parseUUIDField(Object instance, Field field, String path, ForgeConfigSpec.Builder builder) throws IllegalAccessException {
        UUID defaultValue = (UUID)field.get(instance);
        ForgeConfigSpec.ConfigValue configValue = builder.define(path, (Object)defaultValue.toString());
        return new ConfigFieldPair<String>(field, configValue, UUID::fromString);
    }

    private static ConfigFieldPair<?> parseResourceLocationField(Object instance, Field field, String path, ForgeConfigSpec.Builder builder) throws IllegalAccessException {
        ResourceLocation defaultValue = (ResourceLocation)field.get(instance);
        ForgeConfigSpec.ConfigValue configValue = builder.define(path, (Object)defaultValue.toString());
        return new ConfigFieldPair<String>(field, configValue, ResourceLocation::new);
    }

    private static String getPath(@Nullable String prefix, Field field) {
        return (String)(prefix != null ? prefix + "." : "") + field.getName();
    }

    private static double getMin(Field field) {
        Min minAnnotation = field.getAnnotation(Min.class);
        return minAnnotation != null ? minAnnotation.value() : 0.0;
    }

    private static double getMax(Field field) {
        Max maxAnnotation = field.getAnnotation(Max.class);
        return maxAnnotation != null ? maxAnnotation.value() : Double.POSITIVE_INFINITY;
    }

    static {
        PARSERS.put(Integer.TYPE, ConfigManager::parseIntField);
        PARSERS.put(Long.TYPE, ConfigManager::parseLongField);
        PARSERS.put(Double.TYPE, ConfigManager::parseDoubleField);
        PARSERS.put(String.class, ConfigManager::parseStringField);
        PARSERS.put(UUID.class, ConfigManager::parseUUIDField);
        PARSERS.put(ResourceLocation.class, ConfigManager::parseResourceLocationField);
    }

    private record ConfigDefinition(Object instance, ArrayList<ConfigFieldPair<?>> values) {
        public void apply() {
            for (ConfigFieldPair<?> pair : this.values) {
                pair.apply(this.instance);
            }
        }
    }

    @FunctionalInterface
    private static interface ConfigFieldParser {
        public ConfigFieldPair<?> apply(Object var1, Field var2, String var3, ForgeConfigSpec.Builder var4) throws IllegalAccessException;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Path {
        public String value() default "";
    }

    private static final class ConfigFieldPair<T> {
        public final Field field;
        public final ForgeConfigSpec.ConfigValue<T> value;
        private final Function<T, Object> converter;

        public ConfigFieldPair(Field field, ForgeConfigSpec.ConfigValue<T> value, Function<T, Object> converter) {
            this.field = field;
            this.value = value;
            this.converter = converter;
        }

        public ConfigFieldPair(Field field, ForgeConfigSpec.ConfigValue<T> value) {
            this(field, value, x -> x);
        }

        public void apply(Object instance) {
            try {
                this.field.set(instance, this.converter.apply(this.value.get()));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Min {
        public double value() default 0.0;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Max {
        public double value() default Infinity;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Type {
        public ModConfig.Type value() default ModConfig.Type.COMMON;
    }
}

