/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.renderer.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import li.cil.oc2.common.entity.Robot;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.model.TransformationHelper;

public final class RobotModel
extends EntityModel<Robot> {
    public static final ModelLayerLocation ROBOT_MODEL_LAYER = new ModelLayerLocation(new ResourceLocation("oc2", "robot"), "main");
    public static final ResourceLocation ROBOT_ENTITY_TEXTURE = new ResourceLocation("oc2", "textures/entity/robot/robot.png");
    private final ModelPart topRenderer;
    private final ModelPart baseRenderer;
    private final ModelPart coreRenderer;
    private float baseY;
    private float topY;
    private final float[] topRotation = new float[3];

    public RobotModel(ModelPart modelPart) {
        this.topRenderer = modelPart.m_171324_("top");
        this.baseRenderer = modelPart.m_171324_("base");
        this.coreRenderer = modelPart.m_171324_("core");
    }

    public static LayerDefinition createRobotLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("top", CubeListBuilder.m_171558_().m_171514_(1, 1).m_171481_(-7.0f, 8.0f, -7.0f, 14.0f, 6.0f, 14.0f), PartPose.f_171404_);
        partDefinition.m_171599_("base", CubeListBuilder.m_171558_().m_171514_(1, 23).m_171481_(-7.0f, 0.0f, -7.0f, 14.0f, 7.0f, 14.0f), PartPose.f_171404_);
        partDefinition.m_171599_("core", CubeListBuilder.m_171558_().m_171514_(1, 34).m_171481_(-6.0f, 7.0f, -6.0f, 12.0f, 1.0f, 12.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void setupAnim(Robot entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        Robot.AnimationState state = entity.getAnimationState();
        this.baseY = state.baseRenderOffsetY;
        this.topY = state.topRenderOffsetY;
        this.topRotation[1] = state.topRenderRotationY;
    }

    public void m_7695_(PoseStack stack, VertexConsumer consumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        stack.m_85836_();
        stack.m_85837_(0.0, (double)this.topY, 0.0);
        stack.m_85845_(TransformationHelper.quatFromXYZ((float[])this.topRotation, (boolean)true));
        this.topRenderer.m_104301_(stack, consumer, packedLight, packedOverlay);
        stack.m_85849_();
        stack.m_85836_();
        stack.m_85837_(0.0, (double)this.baseY, 0.0);
        this.baseRenderer.m_104301_(stack, consumer, packedLight, packedOverlay);
        this.coreRenderer.m_104301_(stack, consumer, LightTexture.m_109885_((int)15, (int)15), packedOverlay);
        stack.m_85849_();
    }
}

