/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import li.cil.oc2.client.gui.Sprites;
import li.cil.oc2.client.gui.Textures;
import li.cil.oc2.client.gui.widget.Texture;
import li.cil.oc2.client.renderer.ModRenderType;
import li.cil.oc2.common.item.Items;
import li.cil.oc2.common.item.NetworkInterfaceCardItem;
import li.cil.oc2.common.network.Network;
import li.cil.oc2.common.network.message.NetworkInterfaceCardConfigurationMessage;
import li.cil.oc2.common.util.TranslationUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class NetworkInterfaceCardScreen
extends Screen {
    private static final String SIDE_STATE_TEXT = TranslationUtils.key("gui.{mod}.network_interface_card.side_state");
    private static final Component CONNECTIVITY_ENABLED_TEXT = TranslationUtils.text("gui.{mod}.network_interface_card.connectivity.enabled");
    private static final Component CONNECTIVITY_DISABLED_TEXT = TranslationUtils.text("gui.{mod}.network_interface_card.connectivity.disabled");
    private static final Component INFO_TEXT = TranslationUtils.text("gui.{mod}.network_interface_card.info");
    public static final int UI_WIDTH = Sprites.NETWORK_INTERFACE_CARD_SCREEN.width;
    public static final int UI_HEIGHT = Sprites.NETWORK_INTERFACE_CARD_SCREEN.height;
    public static final int BLOCK_LEFT = UI_WIDTH / 2;
    public static final int BLOCK_TOP = 53;
    public static final int INFO_TEXT_LEFT = 8;
    public static final int INFO_TEXT_TOP = 104;
    public static final int INFO_TEXT_WIDTH = UI_WIDTH - 16;
    public static final int MAX_BLOCK_PITCH = 30;
    private final Player player;
    private final InteractionHand hand;
    private final ComputerBlockItemRenderer computerBlockItemRenderer = new ComputerBlockItemRenderer();
    private Vector3f blockRotation = new Vector3f(-30.0f, 45.0f, 0.0f);
    private int left;
    private int top;
    @Nullable
    private Direction focusedSide;
    private boolean isDraggingBlock;
    private boolean hasDraggedBlock;
    private double dragStartX;
    private double dragStartY;

    public NetworkInterfaceCardScreen(Player player, InteractionHand hand) {
        super(((Item)Items.NETWORK_INTERFACE_CARD.get()).m_41466_());
        this.player = player;
        this.hand = hand;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.left = (this.f_96543_ - UI_WIDTH) / 2;
        this.top = (this.f_96544_ - UI_HEIGHT) / 2;
    }

    public void m_96624_() {
        super.m_96624_();
        ItemStack heldItem = this.player.m_21120_(this.hand);
        if (!heldItem.m_150930_((Item)Items.NETWORK_INTERFACE_CARD.get())) {
            this.m_7379_();
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean result = super.m_6375_(mouseX, mouseY, button);
        if (!result && this.isMouseInBlockArea(mouseX, mouseY) && button == 0) {
            this.isDraggingBlock = true;
            this.hasDraggedBlock = false;
            this.dragStartX = mouseX;
            this.dragStartY = mouseY;
        }
        return result;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.isDraggingBlock && button == 0) {
            this.isDraggingBlock = false;
            if (!this.hasDraggedBlock && this.focusedSide != null) {
                NetworkInterfaceCardConfigurationMessage message = new NetworkInterfaceCardConfigurationMessage(this.hand, this.focusedSide, !this.getConfiguration(this.focusedSide));
                Network.sendToServer(message);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            }
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int activeButton, double deltaX, double deltaY) {
        if (this.isDraggingBlock && activeButton == 0) {
            if (!this.hasDraggedBlock) {
                double dx = mouseX - this.dragStartX;
                double dy = mouseY - this.dragStartY;
                double delta = Math.sqrt(dx * dx + dy * dy);
                boolean bl = this.hasDraggedBlock = delta > 3.0;
            }
            if (this.hasDraggedBlock) {
                this.blockRotation = new Vector3f(Mth.m_14036_((float)(this.blockRotation.m_122239_() - (float)deltaY), (float)-30.0f, (float)30.0f), Mth.m_14177_((float)(this.blockRotation.m_122260_() + (float)deltaX)), this.blockRotation.m_122269_());
            }
        }
        return true;
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        Sprites.NETWORK_INTERFACE_CARD_SCREEN.draw(stack, this.left, this.top);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        int blockX = this.left + BLOCK_LEFT;
        int blockY = this.top + 53;
        this.focusedSide = this.computerBlockItemRenderer.getFocusedSide(blockX - mouseX, blockY - mouseY, this.blockRotation);
        this.computerBlockItemRenderer.render(blockX, blockY, this.blockRotation);
        if (this.focusedSide != null) {
            Component enabledComponent = this.getConfiguration(this.focusedSide) ? CONNECTIVITY_ENABLED_TEXT : CONNECTIVITY_DISABLED_TEXT;
            TranslatableComponent tooltip = new TranslatableComponent(SIDE_STATE_TEXT, new Object[]{enabledComponent});
            this.m_96602_(stack, (Component)tooltip, mouseX, mouseY);
        }
        this.f_96547_.m_92857_((FormattedText)INFO_TEXT, this.left + 8, this.top + 104, INFO_TEXT_WIDTH, 0xAAAAAA);
    }

    public boolean m_7043_() {
        return false;
    }

    private boolean isMouseInBlockArea(double mouseX, double mouseY) {
        return mouseX >= (double)(this.left + 37) && mouseX <= (double)(this.left + 139) && mouseY >= (double)(this.top + 10) && mouseY <= (double)(this.top + 112);
    }

    private boolean getConfiguration(@Nullable Direction side) {
        return side != null && NetworkInterfaceCardItem.getSideConfiguration(this.player.m_21120_(this.hand), side);
    }

    private final class ComputerBlockItemRenderer {
        public static final int BLOCK_RENDER_SIZE = 48;
        private final ItemStack computerItemStack = new ItemStack((ItemLike)Items.COMPUTER.get());
        private final ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        private final BakedModel model = this.itemRenderer.m_174264_(this.computerItemStack, null, null, 0);

        private ComputerBlockItemRenderer() {
        }

        @Nullable
        private Direction getFocusedSide(float mouseX, float mouseY, Vector3f rotation) {
            Quaternion quaternion = Quaternion.m_175225_((Vector3f)rotation);
            quaternion.m_80157_();
            float relMouseX = -mouseX / 48.0f;
            float relMouseY = -mouseY / 48.0f;
            Vector3f source = new Vector3f();
            source.m_122272_(relMouseX, relMouseY, 1.0f);
            source.m_122251_(quaternion);
            Vector3f target = new Vector3f();
            target.m_122272_(relMouseX, relMouseY, -1.0f);
            target.m_122251_(quaternion);
            AABB aabb = new AABB(-0.5, -0.5, -0.5, 0.5, 0.5, 0.5);
            return aabb.m_82371_(new Vec3(source), new Vec3(target)).map(hit -> Direction.m_122366_((double)hit.f_82479_, (double)(-hit.m_7098_()), (double)hit.m_7094_())).filter(side -> side != Direction.SOUTH).orElse(null);
        }

        public void render(int x, int y, Vector3f rotation) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            RenderSystem.m_69478_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Vector3f renderRotation = rotation.m_122281_();
            renderRotation.m_122272_(0.0f, 180.0f, 0.0f);
            PoseStack stack = RenderSystem.m_157191_();
            stack.m_85836_();
            stack.m_85837_((double)x, (double)y, 0.0);
            stack.m_85845_(Quaternion.m_175225_((Vector3f)renderRotation));
            stack.m_85841_(48.0f, -48.0f, 48.0f);
            RenderSystem.m_157182_();
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            this.renderBlock(bufferSource);
            this.renderOverlays(stack, bufferSource);
            bufferSource.m_109911_();
            stack.m_85849_();
            RenderSystem.m_157182_();
        }

        private void renderBlock(MultiBufferSource.BufferSource bufferSource) {
            this.itemRenderer.m_115143_(this.computerItemStack, ItemTransforms.TransformType.NONE, false, new PoseStack(), (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, this.model);
        }

        private void renderOverlays(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource) {
            for (Direction side : Direction.values()) {
                if (side == Direction.SOUTH) continue;
                poseStack.m_85836_();
                poseStack.m_166856_();
                poseStack.m_85837_((double)(-side.m_122429_()) * 0.51, (double)side.m_122430_() * 0.51, (double)(-side.m_122431_()) * 0.51);
                Vector3f sideRotation = switch (side) {
                    case Direction.DOWN -> new Vector3f(-90.0f, 0.0f, 0.0f);
                    case Direction.UP -> new Vector3f(90.0f, 0.0f, 0.0f);
                    case Direction.NORTH -> new Vector3f(0.0f, 180.0f, 0.0f);
                    case Direction.WEST -> new Vector3f(0.0f, -90.0f, 0.0f);
                    case Direction.EAST -> new Vector3f(0.0f, 90.0f, 0.0f);
                    default -> throw new IllegalStateException("Unexpected value: " + side);
                };
                poseStack.m_85845_(Quaternion.m_175225_((Vector3f)sideRotation));
                poseStack.m_85837_(-0.5, -0.5, 0.0);
                if (NetworkInterfaceCardScreen.this.getConfiguration(side)) {
                    this.renderOverlay(poseStack, bufferSource, Textures.BLOCK_FACE_ENABLED_TEXTURE);
                } else {
                    this.renderOverlay(poseStack, bufferSource, Textures.BLOCK_FACE_DISABLED_TEXTURE);
                }
                if (side == NetworkInterfaceCardScreen.this.focusedSide) {
                    this.renderOverlay(poseStack, bufferSource, Textures.BLOCK_FACE_FOCUSED_TEXTURE);
                }
                poseStack.m_85849_();
            }
        }

        private void renderOverlay(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, Texture texture) {
            VertexConsumer buffer = bufferSource.m_6299_(ModRenderType.getOverlay(texture.location));
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), 0.0f, 1.0f, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), 1.0f, 1.0f, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), 1.0f, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        }
    }
}

