/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import li.cil.oc2.api.bus.device.DeviceTypes;
import li.cil.oc2.client.gui.AbstractModContainerScreen;
import li.cil.oc2.client.gui.Sprites;
import li.cil.oc2.client.gui.util.GuiUtils;
import li.cil.oc2.client.gui.widget.ImageButton;
import li.cil.oc2.client.gui.widget.ToggleImageButton;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.container.AbstractMachineTerminalContainer;
import li.cil.oc2.common.util.TextFormatUtils;
import li.cil.oc2.common.util.TooltipUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractMachineInventoryScreen<T extends AbstractMachineTerminalContainer>
extends AbstractModContainerScreen<T> {
    private static final int CONTROLS_TOP = 8;
    private static final int ENERGY_TOP = 8 + Sprites.SIDEBAR_2.height + 4;

    public AbstractMachineInventoryScreen(T container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
    }

    protected void m_7856_() {
        super.m_7856_();
        (this.m_142416_((GuiEventListener)new ToggleImageButton(this.f_97735_ - Sprites.SIDEBAR_3.width + 4, this.f_97736_ + 8 + 4, 12, 12, Sprites.POWER_BUTTON_BASE, Sprites.POWER_BUTTON_PRESSED, Sprites.POWER_BUTTON_ACTIVE){

            @Override
            public void m_5691_() {
                super.m_5691_();
                ((AbstractMachineTerminalContainer)AbstractMachineInventoryScreen.this.f_97732_).sendPowerStateToServer(!((AbstractMachineTerminalContainer)AbstractMachineInventoryScreen.this.f_97732_).getVirtualMachine().isRunning());
            }

            @Override
            public boolean isToggled() {
                return ((AbstractMachineTerminalContainer)AbstractMachineInventoryScreen.this.f_97732_).getVirtualMachine().isRunning();
            }
        })).withTooltip(new Component[]{new TranslatableComponent(Constants.COMPUTER_SCREEN_POWER_CAPTION), new TranslatableComponent(Constants.COMPUTER_SCREEN_POWER_DESCRIPTION)});
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ - Sprites.SIDEBAR_3.width + 4, this.f_97736_ + 8 + 4 + 14, 12, 12, Sprites.INVENTORY_BUTTON_ACTIVE, Sprites.INVENTORY_BUTTON_INACTIVE){

            @Override
            public void m_5691_() {
                ((AbstractMachineTerminalContainer)AbstractMachineInventoryScreen.this.f_97732_).switchToTerminal();
            }
        }.withTooltip(new Component[]{new TranslatableComponent(Constants.MACHINE_OPEN_TERMINAL_CAPTION)}));
    }

    protected void m_7286_(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Sprites.SIDEBAR_2.draw(stack, this.f_97735_ - Sprites.SIDEBAR_2.width, this.f_97736_ + 8);
        if (this.shouldRenderEnergyBar()) {
            int x = this.f_97735_ - Sprites.SIDEBAR_2.width;
            int y = this.f_97736_ + ENERGY_TOP;
            Sprites.SIDEBAR_2.draw(stack, x, y);
            Sprites.ENERGY_BASE.draw(stack, x + 4, y + 4);
        }
    }

    @Override
    protected void renderFg(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        super.renderFg(stack, partialTicks, mouseX, mouseY);
        GuiUtils.renderMissingDeviceInfoIcon(stack, this, DeviceTypes.FLASH_MEMORY, Sprites.WARN_ICON);
        GuiUtils.renderMissingDeviceInfoIcon(stack, this, DeviceTypes.MEMORY, Sprites.WARN_ICON);
        GuiUtils.renderMissingDeviceInfoIcon(stack, this, DeviceTypes.HARD_DRIVE, Sprites.INFO_ICON);
        if (this.shouldRenderEnergyBar()) {
            int x = this.f_97735_ - Sprites.SIDEBAR_2.width + 4;
            int y = this.f_97736_ + ENERGY_TOP + 4;
            Sprites.ENERGY_BAR.drawFillY(stack, x, y, (float)((AbstractMachineTerminalContainer)this.f_97732_).getEnergy() / (float)((AbstractMachineTerminalContainer)this.f_97732_).getEnergyCapacity());
        }
    }

    @Override
    protected void m_7025_(PoseStack stack, int mouseX, int mouseY) {
        super.m_7025_(stack, mouseX, mouseY);
        GuiUtils.renderMissingDeviceInfoTooltip(stack, this, mouseX, mouseY, DeviceTypes.FLASH_MEMORY);
        GuiUtils.renderMissingDeviceInfoTooltip(stack, this, mouseX, mouseY, DeviceTypes.MEMORY);
        GuiUtils.renderMissingDeviceInfoTooltip(stack, this, mouseX, mouseY, DeviceTypes.HARD_DRIVE);
        if (this.shouldRenderEnergyBar() && this.isMouseOver(mouseX, mouseY, -Sprites.SIDEBAR_2.width + 4, ENERGY_TOP + 4, Sprites.ENERGY_BAR.width, Sprites.ENERGY_BAR.height)) {
            List<TranslatableComponent> tooltip = Arrays.asList(new TranslatableComponent(Constants.TOOLTIP_ENERGY, new Object[]{TextFormatUtils.withFormat(((AbstractMachineTerminalContainer)this.f_97732_).getEnergy() + "/" + ((AbstractMachineTerminalContainer)this.f_97732_).getEnergyCapacity(), ChatFormatting.GREEN)}), new TranslatableComponent(Constants.TOOLTIP_ENERGY_CONSUMPTION, new Object[]{TextFormatUtils.withFormat(String.valueOf(((AbstractMachineTerminalContainer)this.f_97732_).getEnergyConsumption()), ChatFormatting.GREEN)}));
            TooltipUtils.drawTooltip(stack, tooltip, mouseX, mouseY, 200);
        }
    }

    private boolean shouldRenderEnergyBar() {
        return ((AbstractMachineTerminalContainer)this.f_97732_).getEnergyCapacity() > 0;
    }
}

