/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.item;

import java.util.List;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.cookingforblockheads.item.ModItems;
import net.blay09.mods.cookingforblockheads.menu.ModMenus;
import net.blay09.mods.cookingforblockheads.menu.RecipeBookMenu;
import net.blay09.mods.cookingforblockheads.util.TextUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemRecipeBook
extends Item {
    private final RecipeBookEdition edition;

    public ItemRecipeBook(RecipeBookEdition edition) {
        super(new Item.Properties().m_41491_(ModItems.creativeModeTab).m_41487_(1));
        this.edition = edition;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!level.f_46443_) {
            Balm.getNetworking().openGui(player, (MenuProvider)new BalmMenuProvider(){

                public Component m_5446_() {
                    return new TranslatableComponent("cookingforblockheads:" + ItemRecipeBook.this.edition.getName());
                }

                public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                    RecipeBookMenu container = new RecipeBookMenu(ItemRecipeBook.this.edition.getContainerTypeSupplier().get(), i, playerEntity);
                    if (ItemRecipeBook.this.edition == RecipeBookEdition.NO_FILTER) {
                        container.setNoFilter();
                    } else if (ItemRecipeBook.this.edition == RecipeBookEdition.CRAFTING) {
                        container.allowCrafting();
                    }
                    return container;
                }
            });
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(itemStack, level, tooltip, flag);
        String editionName = this.edition.getName();
        tooltip.add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:" + editionName, ChatFormatting.YELLOW));
        for (String s : I18n.m_118938_((String)("tooltip.cookingforblockheads:" + editionName + ".description"), (Object[])new Object[0]).split("\\\\n")) {
            tooltip.add(TextUtils.coloredTextComponent(s, ChatFormatting.GRAY));
        }
    }

    public static enum RecipeBookEdition {
        NO_FILTER("no_filter_edition", () -> (MenuType)ModMenus.noFilterBook.get()),
        RECIPE("recipe_book", () -> (MenuType)ModMenus.recipeBook.get()),
        CRAFTING("crafting_book", () -> (MenuType)ModMenus.craftingBook.get());

        private final String name;
        private final Supplier<MenuType<RecipeBookMenu>> containerTypeSupplier;

        private RecipeBookEdition(String name, Supplier<MenuType<RecipeBookMenu>> containerTypeSupplier) {
            this.name = name;
            this.containerTypeSupplier = containerTypeSupplier;
        }

        public String getName() {
            return this.name;
        }

        public Supplier<MenuType<RecipeBookMenu>> getContainerTypeSupplier() {
            return this.containerTypeSupplier;
        }
    }
}

