/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat;

import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.block.FridgeBlock;
import net.blay09.mods.cookingforblockheads.block.MilkJarBlock;
import net.blay09.mods.cookingforblockheads.block.OvenBlock;
import net.blay09.mods.cookingforblockheads.block.SinkBlock;
import net.blay09.mods.cookingforblockheads.block.ToasterBlock;
import net.blay09.mods.cookingforblockheads.tile.CowJarBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.FridgeBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.MilkJarBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.OvenBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.SinkBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.ToasterBlockEntity;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;

@WailaPlugin(id="cookingforblockheads")
public class WailaAddon
implements IWailaPlugin {
    public void register(IRegistrar registrar) {
        registrar.addComponent((IBlockComponentProvider)new MilkJarDataProvider(), TooltipPosition.HEAD, MilkJarBlock.class);
        registrar.addComponent((IBlockComponentProvider)new ToasterDataProvider(), TooltipPosition.BODY, ToasterBlock.class);
        registrar.addComponent((IBlockComponentProvider)new OvenDataProvider(), TooltipPosition.BODY, OvenBlock.class);
        registrar.addComponent((IBlockComponentProvider)new FridgeDataProvider(), TooltipPosition.BODY, FridgeBlock.class);
        registrar.addComponent((IBlockComponentProvider)new SinkDataProvider(), TooltipPosition.BODY, SinkBlock.class);
    }

    public static class MilkJarDataProvider
    implements IBlockComponentProvider {
        public void appendHead(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            CowJarBlockEntity cowJar;
            BlockEntity blockEntity = accessor.getBlockEntity();
            if (blockEntity instanceof CowJarBlockEntity && (cowJar = (CowJarBlockEntity)blockEntity).m_7770_() != null) {
                tooltip.add(cowJar.m_7770_());
            }
        }

        public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            BlockEntity blockEntity = accessor.getBlockEntity();
            if (blockEntity instanceof MilkJarBlockEntity) {
                MilkJarBlockEntity milkJar = (MilkJarBlockEntity)blockEntity;
                FluidTank fluidTank = milkJar.getFluidTank();
                tooltip.add((Component)new TranslatableComponent("waila.cookingforblockheads:milk_stored", new Object[]{fluidTank.getAmount(), fluidTank.getCapacity()}));
            }
        }
    }

    public static class ToasterDataProvider
    implements IBlockComponentProvider {
        public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            ToasterBlockEntity toaster;
            BlockEntity blockEntity = accessor.getBlockEntity();
            if (blockEntity instanceof ToasterBlockEntity && (toaster = (ToasterBlockEntity)blockEntity).isActive()) {
                tooltip.add((Component)new TranslatableComponent("waila.cookingforblockheads:toast_progress", new Object[]{(int)(toaster.getToastProgress() * 100.0f)}));
            }
        }
    }

    public static class OvenDataProvider
    implements IBlockComponentProvider {
        public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            OvenBlockEntity oven;
            BlockEntity tileEntity = accessor.getBlockEntity();
            if (tileEntity instanceof OvenBlockEntity && (oven = (OvenBlockEntity)tileEntity).hasPowerUpgrade()) {
                tooltip.add((Component)new TranslatableComponent("waila.cookingforblockheads:heating_unit"));
            }
        }
    }

    public static class FridgeDataProvider
    implements IBlockComponentProvider {
        public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            BlockEntity blockEntity = accessor.getBlockEntity();
            if (blockEntity instanceof FridgeBlockEntity) {
                FridgeBlockEntity fridge = (FridgeBlockEntity)blockEntity;
                if (fridge.hasIceUpgrade()) {
                    tooltip.add((Component)new TranslatableComponent("waila.cookingforblockheads:ice_unit"));
                }
                if (fridge.hasPreservationUpgrade()) {
                    tooltip.add((Component)new TranslatableComponent("waila.cookingforblockheads:preservation_chamber"));
                }
            }
        }
    }

    public static class SinkDataProvider
    implements IBlockComponentProvider {
        public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            BlockEntity blockEntity = accessor.getBlockEntity();
            if (blockEntity instanceof SinkBlockEntity) {
                SinkBlockEntity sink = (SinkBlockEntity)blockEntity;
                if (CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                    FluidTank fluidTank = sink.getFluidTank();
                    tooltip.add((Component)new TranslatableComponent("waila.cookingforblockheads:water_stored", new Object[]{fluidTank.getAmount(), fluidTank.getCapacity()}));
                }
            }
        }
    }
}

