/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat;

import java.util.function.Function;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.block.FridgeBlock;
import net.blay09.mods.cookingforblockheads.block.MilkJarBlock;
import net.blay09.mods.cookingforblockheads.block.OvenBlock;
import net.blay09.mods.cookingforblockheads.block.SinkBlock;
import net.blay09.mods.cookingforblockheads.block.ToasterBlock;
import net.blay09.mods.cookingforblockheads.tile.FridgeBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.MilkJarBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.OvenBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.SinkBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.ToasterBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.InterModComms;
import org.jetbrains.annotations.Nullable;

public class TheOneProbeAddon {
    public static void register() {
        InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TopInitializer::new);
    }

    @Nullable
    private static <T extends BlockEntity> T tryGetTileEntity(Level level, BlockPos pos, Class<T> tileClass) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity != null && tileClass.isAssignableFrom(blockEntity.getClass())) {
            return (T)blockEntity;
        }
        return null;
    }

    public static class ProbeInfoProvider
    implements IProbeInfoProvider {
        public ResourceLocation getID() {
            return new ResourceLocation("cookingforblockheads", "cookingforblockheads");
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo info, Player playerEntity, Level level, BlockState state, IProbeHitData data) {
            SinkBlockEntity sink;
            if (state.m_60734_() instanceof MilkJarBlock) {
                MilkJarBlockEntity tileEntity = TheOneProbeAddon.tryGetTileEntity(level, data.getPos(), MilkJarBlockEntity.class);
                if (tileEntity != null) {
                    this.addMilkJarInfo(tileEntity, info);
                }
            } else if (state.m_60734_() instanceof ToasterBlock) {
                ToasterBlockEntity tileEntity = TheOneProbeAddon.tryGetTileEntity(level, data.getPos(), ToasterBlockEntity.class);
                if (tileEntity != null) {
                    this.addToasterInfo(tileEntity, info);
                }
            } else if (state.m_60734_() instanceof OvenBlock) {
                OvenBlockEntity tileEntity = TheOneProbeAddon.tryGetTileEntity(level, data.getPos(), OvenBlockEntity.class);
                if (tileEntity != null && tileEntity.hasPowerUpgrade()) {
                    info.text((Component)new TranslatableComponent("waila.cookingforblockheads:heating_unit"));
                }
            } else if (state.m_60734_() instanceof FridgeBlock) {
                FridgeBlockEntity tileEntity = TheOneProbeAddon.tryGetTileEntity(level, data.getPos(), FridgeBlockEntity.class);
                if (tileEntity != null && tileEntity.getBaseFridge().hasIceUpgrade()) {
                    info.text((Component)new TranslatableComponent("waila.cookingforblockheads:ice_unit"));
                }
                if (tileEntity != null && tileEntity.getBaseFridge().hasPreservationUpgrade()) {
                    info.text((Component)new TranslatableComponent("waila.cookingforblockheads:preservation_chamber"));
                }
            } else if (state.m_60734_() instanceof SinkBlock && (sink = TheOneProbeAddon.tryGetTileEntity(level, data.getPos(), SinkBlockEntity.class)) != null && CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                info.text((Component)new TranslatableComponent("waila.cookingforblockheads:water_stored", new Object[]{sink.getFluidTank().getAmount(), sink.getFluidTank().getCapacity()}));
            }
        }

        private void addMilkJarInfo(MilkJarBlockEntity milkJar, IProbeInfo info) {
            info.text((Component)new TranslatableComponent("waila.cookingforblockheads:milk_stored", new Object[]{milkJar.getFluidTank().getAmount(), milkJar.getFluidTank().getCapacity()}));
        }

        private void addToasterInfo(ToasterBlockEntity tileEntity, IProbeInfo info) {
            if (tileEntity.isActive()) {
                info.text((Component)new TranslatableComponent("waila.cookingforblockheads:toast_progress", new Object[]{(int)(tileEntity.getToastProgress() * 100.0f)}));
                info.progress((int)(tileEntity.getToastProgress() * 100.0f), 100);
            }
        }
    }

    public static class TopInitializer
    implements Function<ITheOneProbe, Void> {
        @Override
        @Nullable
        public Void apply(@Nullable ITheOneProbe top) {
            if (top != null) {
                top.registerProvider((IProbeInfoProvider)new ProbeInfoProvider());
            }
            return null;
        }
    }
}

