/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.UseBlockEvent;
import net.blay09.mods.balm.api.event.client.ItemTooltipEvent;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.blay09.mods.cookingforblockheads.util.TextUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class HarvestCraftAddon {
    private boolean cuttingBoardFound;

    public HarvestCraftAddon() {
        Compat.cuttingBoardItem = Balm.getRegistries().getItem(new ResourceLocation("pamhc2foodcore", "cuttingboarditem"));
        if (Compat.cuttingBoardItem != null && Compat.cuttingBoardItem != Items.f_41852_) {
            this.cuttingBoardFound = true;
        }
        Balm.getEvents().onEvent(ItemTooltipEvent.class, event -> {
            if (!this.cuttingBoardFound) {
                return;
            }
            if (event.getItemStack().m_41720_() == Compat.cuttingBoardItem) {
                event.getToolTip().add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:multiblock_kitchen", ChatFormatting.YELLOW));
                event.getToolTip().add(new TranslatableComponent("tooltip.cookingforblockheads:can_be_placed_in_world"));
            }
        });
        Balm.getEvents().onEvent(UseBlockEvent.class, event -> {
            if (!this.cuttingBoardFound) {
                return;
            }
            ItemStack heldItem = event.getPlayer().m_21120_(event.getHand());
            if (heldItem.m_41720_() != Compat.cuttingBoardItem) {
                return;
            }
            Direction face = event.getHitResult().m_82434_();
            if (face != Direction.UP) {
                return;
            }
            Level level = event.getLevel();
            Player player = event.getPlayer();
            BlockPos pos = event.getHitResult().m_82425_();
            BlockState clickedBlock = level.m_8055_(pos);
            if (clickedBlock.m_60734_() == Blocks.f_50087_ || clickedBlock.m_60734_() == Blocks.f_50091_ || clickedBlock.m_60734_() == ModBlocks.cuttingBoard) {
                return;
            }
            BlockPos relativePos = pos.m_142300_(face);
            if (this.canPlace(player, ModBlocks.cuttingBoard.m_49966_(), level, relativePos)) {
                BlockPlaceContext useContext = new BlockPlaceContext(new UseOnContext(player, event.getHand(), new BlockHitResult(Vec3.m_82528_((Vec3i)relativePos), face, relativePos, true)));
                BlockState placedState = ModBlocks.cuttingBoard.m_5573_(useContext);
                level.m_46597_(relativePos, placedState);
                if (!player.m_150110_().f_35937_) {
                    heldItem.m_41774_(1);
                }
                player.m_6674_(event.getHand());
                player.m_5496_(SoundEvents.f_12635_, 1.0f, 1.0f);
                event.setResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        });
    }

    private boolean canPlace(Player player, BlockState state, Level level, BlockPos pos) {
        CollisionContext context = CollisionContext.m_82750_((Entity)player);
        return state.m_60710_((LevelReader)level, pos) && level.m_45752_(state, pos, context);
    }
}

