/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.LivingDamageEvent;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.network.message.SyncedEffectMessage;
import net.blay09.mods.cookingforblockheads.tile.CowJarBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CowJarHandler {
    private static final List<Class<? extends LivingEntity>> additionalCowClasses = Lists.newArrayList();

    public static void registerCowClass(Class<?> clazz) {
        additionalCowClasses.add(clazz);
    }

    public static void onLivingDamage(LivingDamageEvent event) {
        if (!CookingForBlockheadsConfig.getActive().cowJarEnabled) {
            return;
        }
        if (event.getDamageSource() == DamageSource.f_19321_ && CowJarHandler.isCow(event.getEntity())) {
            LivingEntity entity;
            Level level = entity.f_19853_;
            entity = event.getEntity();
            BlockPos pos = entity.m_142538_();
            BlockState blockBelow = level.m_8055_(pos);
            if (blockBelow.m_60734_() == ModBlocks.milkJar) {
                boolean wasCompressed;
                level.m_46597_(pos, ModBlocks.cowJar.m_49966_());
                BlockEntity tileEntity = level.m_7702_(pos);
                if (tileEntity instanceof CowJarBlockEntity && entity.m_7770_() != null) {
                    TranslatableComponent textComponent = new TranslatableComponent("container.cookingforblockheads.cow_jar_custom", new Object[]{entity.m_7770_()});
                    ((CowJarBlockEntity)tileEntity).setCustomName((Component)textComponent);
                }
                if ((wasCompressed = Balm.getHooks().getPersistentData((Entity)event.getEntity()).m_128469_("excompressum").m_128471_("Compressed")) && tileEntity instanceof CowJarBlockEntity) {
                    ((CowJarBlockEntity)tileEntity).setCompressedCow(true);
                }
            }
            Balm.getNetworking().sendToTracking((Entity)entity, (Object)new SyncedEffectMessage(pos, SyncedEffectMessage.Type.COW_IN_A_JAR));
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
            event.setCanceled(true);
        }
    }

    public static boolean isCow(LivingEntity entity) {
        if (entity instanceof Cow) {
            return true;
        }
        for (Class<? extends LivingEntity> clazz : additionalCowClasses) {
            if (!clazz.isAssignableFrom(entity.getClass())) continue;
            return true;
        }
        ResourceLocation registryName = Balm.getRegistries().getKey(entity.m_6095_());
        return registryName != null && registryName.m_135815_().contains("cow");
    }
}

