/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.graphics.shader;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import xaero.map.graphics.shader.WorldMapShader;

public class MapShaders {
    public static WorldMapShader WORLD_MAP = null;
    public static ShaderInstance WORLD_MAP_BRANCH = null;
    public static ShaderInstance POSITION_COLOR_TEX = null;
    public static ShaderInstance POSITION_COLOR_TEX_PRE = null;
    public static ShaderInstance POSITION_COLOR = null;
    private static boolean firstTime = true;

    public static void onResourceReload(ResourceManager resourceManager) {
        String errorMessage = "Couldn't reload the world map shaders!";
        try {
            WORLD_MAP = MapShaders.reloadShader(WORLD_MAP, new WorldMapShader((ResourceProvider)resourceManager));
            WORLD_MAP_BRANCH = MapShaders.reloadShader(WORLD_MAP_BRANCH, new ShaderInstance((ResourceProvider)resourceManager, "xaeroworldmap/map_branch", DefaultVertexFormat.f_85817_));
            POSITION_COLOR_TEX = MapShaders.reloadShader(POSITION_COLOR_TEX, new ShaderInstance((ResourceProvider)resourceManager, "xaeroworldmap/position_color_tex", DefaultVertexFormat.f_85818_));
            POSITION_COLOR_TEX_PRE = MapShaders.reloadShader(POSITION_COLOR_TEX_PRE, new ShaderInstance((ResourceProvider)resourceManager, "xaeroworldmap/position_color_tex_pre", DefaultVertexFormat.f_85818_));
            POSITION_COLOR = MapShaders.reloadShader(POSITION_COLOR, new ShaderInstance((ResourceProvider)resourceManager, "xaeroworldmap/position_color", DefaultVertexFormat.f_85815_));
            System.out.println("Successfully reloaded the world map shaders!");
        }
        catch (IOException e) {
            if (firstTime) {
                throw new RuntimeException("Couldn't reload the world map shaders!", e);
            }
            System.out.println("Couldn't reload the world map shaders!");
            e.printStackTrace();
        }
        firstTime = false;
    }

    private static <S extends ShaderInstance> S reloadShader(S current, S newOne) throws IOException {
        if (current != null) {
            current.close();
        }
        return newOne;
    }
}

