/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.biome;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.biome.BiomeColorCalculator;
import xaero.map.cache.BrokenBlockTintCache;
import xaero.map.region.MapTile;

public class BlockTintProvider
implements BlockAndTintGetter {
    private final Registry<Biome> biomeRegistry;
    private final BiomeColorCalculator calculator;
    private final BlockPos.MutableBlockPos mutablePos;
    private final MapProcessor mapProcessor;
    private final BrokenBlockTintCache brokenBlockTintCache;
    private BlockState state;
    private boolean overlay;
    private MapTile tile;

    public BlockTintProvider(Registry<Biome> biomeRegistry, BiomeColorCalculator calculator, MapProcessor mapProcessor, BrokenBlockTintCache brokenBlockTintCache) {
        this.biomeRegistry = biomeRegistry;
        this.calculator = calculator;
        this.mutablePos = new BlockPos.MutableBlockPos();
        this.mapProcessor = mapProcessor;
        this.brokenBlockTintCache = brokenBlockTintCache;
    }

    public int m_141928_() {
        return 16;
    }

    public int m_141937_() {
        return this.mutablePos.m_123342_() >> 4 << 4;
    }

    public BlockEntity m_7702_(BlockPos blockPos) {
        return null;
    }

    public BlockState m_8055_(BlockPos blockPos) {
        return this.state;
    }

    public FluidState m_6425_(BlockPos blockPos) {
        return this.state == null ? null : this.state.m_60819_();
    }

    public float m_7717_(Direction direction, boolean bl) {
        return 1.0f;
    }

    public LevelLightEngine m_5518_() {
        return null;
    }

    public int m_6171_(BlockPos blockPos, ColorResolver colorResolver) {
        this.mutablePos.m_122190_((Vec3i)blockPos);
        return this.calculator.getBiomeColor(colorResolver, this.overlay, this.mutablePos, this.tile, this.biomeRegistry, this.mapProcessor);
    }

    public int getBiomeColor(BlockPos blockPos, BlockState state, boolean overlay, MapTile tile, int tint) {
        if (this.brokenBlockTintCache.isBroken(state)) {
            return -1;
        }
        this.mutablePos.m_122190_((Vec3i)blockPos);
        this.state = state;
        this.overlay = overlay;
        this.tile = tile;
        try {
            return Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)this, blockPos, tint);
        }
        catch (Throwable t) {
            this.brokenBlockTintCache.setBroken(state);
            WorldMap.LOGGER.error("Error calculating block tint for block state " + state + "! Total: " + this.brokenBlockTintCache.getSize(), t);
            return -1;
        }
    }
}

