/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.trees.feature;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.world.worldgen.trees.config.SlimeTreeConfig;

public class SlimeTreeFeature
extends Feature<SlimeTreeConfig> {
    public SlimeTreeFeature(Codec<SlimeTreeConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<SlimeTreeConfig> context) {
        HashSet trunkPos = Sets.newHashSet();
        HashSet foliagePos = Sets.newHashSet();
        HashSet leavesPos = Sets.newHashSet();
        BoundingBox boundingBox = BoundingBox.m_71044_();
        WorldGenLevel level = context.m_159774_();
        boolean placed = this.place((LevelSimulatedRW)level, context.m_159776_(), context.m_159777_(), trunkPos, foliagePos, boundingBox, (SlimeTreeConfig)context.m_159778_());
        if (boundingBox.m_162395_() <= boundingBox.m_162399_() && placed && !trunkPos.isEmpty()) {
            DiscreteVoxelShape voxelshapepart = this.updateLeaves((LevelAccessor)level, boundingBox, trunkPos, leavesPos);
            StructureTemplate.m_74510_((LevelAccessor)level, (int)3, (DiscreteVoxelShape)voxelshapepart, (int)boundingBox.m_162395_(), (int)boundingBox.m_162396_(), (int)boundingBox.m_162398_());
            return true;
        }
        return false;
    }

    private boolean place(LevelSimulatedRW generationReader, Random rand, BlockPos positionIn, Set<BlockPos> trunkBlockPosSet, Set<BlockPos> foliagePositions, BoundingBox boundingBoxIn, SlimeTreeConfig configIn) {
        if (!(generationReader instanceof LevelAccessor)) {
            return false;
        }
        int height = rand.nextInt(configIn.randomHeight) + configIn.baseHeight;
        if (configIn.canDoubleHeight && rand.nextInt(10) == 0) {
            height *= 2;
        }
        if (positionIn.m_123342_() >= 1 && positionIn.m_123342_() + height + 1 <= 256 && SlimeTreeFeature.isSlimySoilAt((LevelSimulatedReader)generationReader, positionIn.m_7495_())) {
            this.setDirtAt(generationReader, positionIn.m_7495_(), positionIn);
            this.placeTrunk(generationReader, rand, height, positionIn, trunkBlockPosSet, boundingBoxIn, configIn);
            this.placeCanopy(generationReader, rand, height, positionIn, trunkBlockPosSet, boundingBoxIn, configIn);
            return true;
        }
        return false;
    }

    protected void setDirtAt(LevelSimulatedRW reader, BlockPos pos, BlockPos origin) {
        if (!(reader instanceof LevelAccessor)) {
            return;
        }
        BlockState state = ((LevelAccessor)reader).m_8055_(pos);
        if (state.m_60620_((Tag)BlockTags.f_144274_)) {
            reader.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        }
    }

    protected void placeTrunk(LevelSimulatedRW worldIn, Random randomIn, int treeHeight, BlockPos blockPos, Set<BlockPos> blockPosSet, BoundingBox mutableBoundingBoxIn, SlimeTreeConfig treeFeatureConfigIn) {
        while (treeHeight > 0) {
            this.setLog(worldIn, randomIn, blockPos, blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
            blockPos = blockPos.m_7494_();
            --treeHeight;
        }
    }

    protected void placeCanopy(LevelSimulatedRW worldIn, Random randomIn, int treeHeight, BlockPos blockPos, Set<BlockPos> blockPosSet, BoundingBox mutableBoundingBoxIn, SlimeTreeConfig treeFeatureConfigIn) {
        blockPos = blockPos.m_6630_(treeHeight);
        for (int i = 0; i < 4; ++i) {
            this.placeDiamondLayer(worldIn, randomIn, i + 1, blockPos.m_6625_(i), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
        }
        blockPos = blockPos.m_6625_(3);
        this.placeAir(worldIn, randomIn, blockPos.m_142082_(4, 0, 0), blockPosSet, mutableBoundingBoxIn);
        this.placeAir(worldIn, randomIn, blockPos.m_142082_(-4, 0, 0), blockPosSet, mutableBoundingBoxIn);
        this.placeAir(worldIn, randomIn, blockPos.m_142082_(0, 0, 4), blockPosSet, mutableBoundingBoxIn);
        this.placeAir(worldIn, randomIn, blockPos.m_142082_(0, 0, -4), blockPosSet, mutableBoundingBoxIn);
        if (treeFeatureConfigIn.hasVines) {
            this.placeAir(worldIn, randomIn, blockPos.m_142082_(1, 0, 1), blockPosSet, mutableBoundingBoxIn);
            this.placeAir(worldIn, randomIn, blockPos.m_142082_(1, 0, -1), blockPosSet, mutableBoundingBoxIn);
            this.placeAir(worldIn, randomIn, blockPos.m_142082_(-1, 0, 1), blockPosSet, mutableBoundingBoxIn);
            this.placeAir(worldIn, randomIn, blockPos.m_142082_(-1, 0, -1), blockPosSet, mutableBoundingBoxIn);
        }
        blockPos = blockPos.m_7495_();
        this.setLeaf(worldIn, randomIn, blockPos.m_142082_(3, 0, 0), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
        this.setLeaf(worldIn, randomIn, blockPos.m_142082_(-3, 0, 0), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
        this.setLeaf(worldIn, randomIn, blockPos.m_142082_(0, 0, -3), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
        this.setLeaf(worldIn, randomIn, blockPos.m_142082_(0, 0, 3), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
        if (!treeFeatureConfigIn.hasVines) {
            this.setLeaf(worldIn, randomIn, blockPos.m_142082_(1, 0, 1), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
            this.setLeaf(worldIn, randomIn, blockPos.m_142082_(-3, 0, 0), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
            this.setLeaf(worldIn, randomIn, blockPos.m_142082_(-1, 0, 1), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
            this.setLeaf(worldIn, randomIn, blockPos.m_142082_(-1, 0, -1), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
        }
        if (treeFeatureConfigIn.hasVines) {
            blockPos = blockPos.m_7495_();
            this.placeVine(worldIn, randomIn, blockPos.m_142082_(3, 0, 0), blockPosSet, mutableBoundingBoxIn, (BlockState)this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn).m_61124_((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.m_142082_(-3, 0, 0), blockPosSet, mutableBoundingBoxIn, (BlockState)this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn).m_61124_((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.m_142082_(0, 0, -3), blockPosSet, mutableBoundingBoxIn, (BlockState)this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn).m_61124_((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.m_142082_(0, 0, 3), blockPosSet, mutableBoundingBoxIn, (BlockState)this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn).m_61124_((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)));
            BlockState randomVine = this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn);
            this.placeVine(worldIn, randomIn, blockPos.m_142082_(2, 1, 2), blockPosSet, mutableBoundingBoxIn, (BlockState)randomVine.m_61124_((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.m_142082_(2, 0, 2), blockPosSet, mutableBoundingBoxIn, randomVine);
            randomVine = this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn);
            this.placeVine(worldIn, randomIn, blockPos.m_142082_(2, 1, -2), blockPosSet, mutableBoundingBoxIn, (BlockState)randomVine.m_61124_((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.m_142082_(2, 0, -2), blockPosSet, mutableBoundingBoxIn, randomVine);
            randomVine = this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn);
            this.placeVine(worldIn, randomIn, blockPos.m_142082_(-2, 1, 2), blockPosSet, mutableBoundingBoxIn, (BlockState)randomVine.m_61124_((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.m_142082_(-2, 0, 2), blockPosSet, mutableBoundingBoxIn, randomVine);
            randomVine = this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn);
            this.placeVine(worldIn, randomIn, blockPos.m_142082_(-2, 1, -2), blockPosSet, mutableBoundingBoxIn, (BlockState)randomVine.m_61124_((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.m_142082_(-2, 0, -2), blockPosSet, mutableBoundingBoxIn, randomVine);
        }
    }

    private void placeDiamondLayer(LevelSimulatedRW worldIn, Random randomIn, int range, BlockPos blockPos, Set<BlockPos> blockPosSet, BoundingBox mutableBoundingBoxIn, SlimeTreeConfig treeFeatureConfigIn) {
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                if (Math.abs(x) + Math.abs(z) > range) continue;
                BlockPos blockpos = blockPos.m_142082_(x, 0, z);
                this.setLeaf(worldIn, randomIn, blockpos, blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
            }
        }
    }

    protected boolean setLog(LevelSimulatedRW worldIn, Random randomIn, BlockPos blockPos, Set<BlockPos> blockPosSet, BoundingBox mutableBoundingBoxIn, SlimeTreeConfig treeFeatureConfigIn) {
        if (!SlimeTreeFeature.isAirOrLeavesAt((LevelSimulatedReader)worldIn, blockPos)) {
            return false;
        }
        this.m_5974_((LevelWriter)worldIn, blockPos, treeFeatureConfigIn.trunkProvider.m_7112_(randomIn, blockPos));
        blockPosSet.add(blockPos.m_7949_());
        return true;
    }

    protected boolean placeAir(LevelSimulatedRW worldIn, Random random, BlockPos blockPos, Set<BlockPos> blockPosSet, BoundingBox mutableBoundingBoxIn) {
        if (!SlimeTreeFeature.isAirOrLeavesAt((LevelSimulatedReader)worldIn, blockPos)) {
            return false;
        }
        this.m_5974_((LevelWriter)worldIn, blockPos, Blocks.f_50016_.m_49966_());
        blockPosSet.add(blockPos.m_7949_());
        return true;
    }

    protected boolean setLeaf(LevelSimulatedRW worldIn, Random random, BlockPos blockPos, Set<BlockPos> blockPosSet, BoundingBox mutableBoundingBoxIn, SlimeTreeConfig treeFeatureConfigIn) {
        if (!SlimeTreeFeature.isAirOrLeavesAt((LevelSimulatedReader)worldIn, blockPos)) {
            return false;
        }
        this.m_5974_((LevelWriter)worldIn, blockPos, treeFeatureConfigIn.leavesProvider.m_7112_(random, blockPos));
        blockPosSet.add(blockPos.m_7949_());
        return true;
    }

    protected boolean placeVine(LevelSimulatedRW worldIn, Random random, BlockPos blockPos, Set<BlockPos> blockPosSet, BoundingBox mutableBoundingBoxIn, BlockState vineState) {
        if (!SlimeTreeFeature.isAirOrLeavesAt((LevelSimulatedReader)worldIn, blockPos)) {
            return false;
        }
        this.m_5974_((LevelWriter)worldIn, blockPos, vineState);
        blockPosSet.add(blockPos.m_7949_());
        return true;
    }

    private BlockState getRandomizedVine(Random random, BlockPos blockPos, SlimeTreeConfig config) {
        BooleanProperty[] sides;
        BlockState state = config.vinesProvider.m_7112_(random, blockPos);
        for (BooleanProperty side : sides = new BooleanProperty[]{VineBlock.f_57834_, VineBlock.f_57835_, VineBlock.f_57836_, VineBlock.f_57837_}) {
            state = (BlockState)state.m_61124_((Property)side, (Comparable)Boolean.valueOf(false));
        }
        for (int i = random.nextInt(3) + 1; i > 0; --i) {
            state = (BlockState)state.m_61124_((Property)sides[random.nextInt(sides.length)], (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public static boolean isEmptyOrLogAt(LevelSimulatedReader reader, BlockPos blockPos) {
        return SlimeTreeFeature.isReplaceableAt(reader, blockPos) || reader.m_7433_(blockPos, state -> state.m_60620_((Tag)BlockTags.f_13106_));
    }

    private static boolean isVineAt(LevelSimulatedReader reader, BlockPos blockPos) {
        return reader.m_7433_(blockPos, state -> state.m_60713_(Blocks.f_50191_));
    }

    private static boolean isWaterAt(LevelSimulatedReader reader, BlockPos blockPos) {
        return reader.m_7433_(blockPos, state -> state.m_60713_(Blocks.f_49990_));
    }

    public static boolean isAirOrLeavesAt(LevelSimulatedReader reader, BlockPos blockPos) {
        return reader.m_7433_(blockPos, state -> state.m_60795_() || state.m_60620_((Tag)BlockTags.f_13035_));
    }

    private static boolean isSlimySoilAt(LevelSimulatedReader reader, BlockPos blockPos) {
        return reader.m_7433_(blockPos, state -> TinkerTags.Blocks.SLIMY_SOIL.m_8110_((Object)state.m_60734_()));
    }

    private static boolean isTallPlantAt(LevelSimulatedReader reader, BlockPos blockPos) {
        return reader.m_7433_(blockPos, state -> state.m_60767_() == Material.f_76302_);
    }

    public static boolean isReplaceableAt(LevelSimulatedReader reader, BlockPos blockPos) {
        return SlimeTreeFeature.isAirOrLeavesAt(reader, blockPos) || SlimeTreeFeature.isTallPlantAt(reader, blockPos) || SlimeTreeFeature.isWaterAt(reader, blockPos);
    }

    public static void setBlockStateAt(LevelWriter writer, BlockPos blockPos, BlockState state) {
        writer.m_7731_(blockPos, state, 19);
    }

    private DiscreteVoxelShape updateLeaves(LevelAccessor world, BoundingBox boundingBox, Set<BlockPos> logs, Set<BlockPos> leaves) {
        ArrayList distanceList = Lists.newArrayList();
        BitSetDiscreteVoxelShape shapePart = new BitSetDiscreteVoxelShape(boundingBox.m_71056_(), boundingBox.m_71057_(), boundingBox.m_71058_());
        for (int j = 0; j < 6; ++j) {
            distanceList.add(Sets.newHashSet());
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (BlockPos leavePos : Lists.newArrayList(leaves)) {
            if (!boundingBox.m_71051_((Vec3i)leavePos)) continue;
        }
        for (BlockPos logPos : Lists.newArrayList(logs)) {
            if (boundingBox.m_71051_((Vec3i)logPos)) {
                // empty if block
            }
            for (Direction direction : Direction.values()) {
                BlockState blockstate;
                mutable.m_122159_((Vec3i)logPos, direction);
                if (logs.contains(mutable) || !(blockstate = world.m_8055_((BlockPos)mutable)).m_61138_((Property)BlockStateProperties.f_61414_)) continue;
                ((Set)distanceList.get(0)).add(mutable.m_7949_());
                SlimeTreeFeature.setBlockStateAt((LevelWriter)world, (BlockPos)mutable, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(1)));
                if (!boundingBox.m_71051_((Vec3i)mutable)) continue;
            }
        }
        for (int distance = 1; distance < 6; ++distance) {
            Set current = (Set)distanceList.get(distance - 1);
            Set next = (Set)distanceList.get(distance);
            for (BlockPos pos : current) {
                if (boundingBox.m_71051_((Vec3i)pos)) {
                    // empty if block
                }
                for (Direction direction : Direction.values()) {
                    int stateDistance;
                    BlockState state;
                    mutable.m_122159_((Vec3i)pos, direction);
                    if (current.contains(mutable) || next.contains(mutable) || !(state = world.m_8055_((BlockPos)mutable)).m_61138_((Property)BlockStateProperties.f_61414_) || (stateDistance = ((Integer)state.m_61143_((Property)BlockStateProperties.f_61414_)).intValue()) <= distance + 1) continue;
                    BlockState furtherState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(distance + 1));
                    SlimeTreeFeature.setBlockStateAt((LevelWriter)world, (BlockPos)mutable, furtherState);
                    if (boundingBox.m_71051_((Vec3i)mutable)) {
                        // empty if block
                    }
                    next.add(mutable.m_7949_());
                }
            }
        }
        return shapePart;
    }
}

