/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.islands.variants;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.SlimeVineBlock;
import slimeknights.tconstruct.world.worldgen.islands.variants.AbstractSlimeIslandVariant;

public class SkySlimeIslandVariant
extends AbstractSlimeIslandVariant {
    public SkySlimeIslandVariant(int index, SlimeType dirtType) {
        super(index, dirtType, SlimeType.SKY);
    }

    @Override
    public ResourceLocation getStructureName(String variantName) {
        return TConstruct.getResource("slime_islands/sky/" + this.dirtType.m_7912_() + "_" + variantName);
    }

    @Override
    protected SlimeType getCongealedSlimeType(Random random) {
        return random.nextBoolean() ? SlimeType.SKY : SlimeType.EARTH;
    }

    @Override
    public BlockState getLakeFluid() {
        return Objects.requireNonNull(TinkerFluids.skySlime.getBlock()).m_49966_();
    }

    @Override
    @Nullable
    public BlockState getVines() {
        return ((SlimeVineBlock)TinkerWorld.skySlimeVine.get()).m_49966_();
    }

    @Override
    @Nullable
    public ConfiguredFeature<?, ?> getTreeFeature(Random random) {
        return TinkerStructures.skySlimeIslandTree;
    }
}

