/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.islands.variants;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.worldgen.islands.variants.AbstractSlimeIslandVariant;

public class BloodSlimeIslandVariant
extends AbstractSlimeIslandVariant {
    public BloodSlimeIslandVariant(int index) {
        super(index, SlimeType.ICHOR, SlimeType.BLOOD);
    }

    @Override
    public ResourceLocation getStructureName(String variantName) {
        return TConstruct.getResource("slime_islands/blood/" + variantName);
    }

    @Override
    protected SlimeType getCongealedSlimeType(Random random) {
        return random.nextBoolean() ? SlimeType.BLOOD : SlimeType.ICHOR;
    }

    @Override
    public BlockState getLakeFluid() {
        return Objects.requireNonNull(TinkerFluids.magma.getBlock()).m_49966_();
    }

    @Override
    @Nullable
    public ConfiguredFeature<?, ?> getTreeFeature(Random random) {
        return TinkerStructures.bloodSlimeIslandFungus;
    }

    @Override
    public StructureProcessor getStructureProcessor() {
        return BlockIgnoreProcessor.f_74048_;
    }

    private static boolean isLava(WorldGenLevel world, BlockPos pos) {
        return world.m_46859_(pos) || world.m_8055_(pos).m_60734_() == Blocks.f_49991_;
    }

    @Override
    public boolean isPositionValid(WorldGenLevel world, BlockPos pos, ChunkGenerator generator) {
        BlockPos up = pos.m_7494_();
        if (BloodSlimeIslandVariant.isLava(world, up)) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (BloodSlimeIslandVariant.isLava(world, up.m_142300_(direction))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

