/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.HugeFungusConfiguration;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructurePieceType;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.CongealedSlimeBlock;
import slimeknights.tconstruct.world.block.SlimeVineBlock;
import slimeknights.tconstruct.world.worldgen.islands.BloodSlimeIslandStructure;
import slimeknights.tconstruct.world.worldgen.islands.ClayIslandStructure;
import slimeknights.tconstruct.world.worldgen.islands.EarthSlimeIslandStructure;
import slimeknights.tconstruct.world.worldgen.islands.EnderSlimeIslandStructure;
import slimeknights.tconstruct.world.worldgen.islands.SkySlimeIslandStructure;
import slimeknights.tconstruct.world.worldgen.islands.SlimeIslandPiece;
import slimeknights.tconstruct.world.worldgen.trees.SupplierBlockStateProvider;
import slimeknights.tconstruct.world.worldgen.trees.config.SlimeFungusConfig;
import slimeknights.tconstruct.world.worldgen.trees.config.SlimeTreeConfig;
import slimeknights.tconstruct.world.worldgen.trees.feature.SlimeFungusFeature;
import slimeknights.tconstruct.world.worldgen.trees.feature.SlimeTreeFeature;

public final class TinkerStructures
extends TinkerModule {
    private static boolean structureSettingsReady = false;
    static final Logger log = Util.getLogger("tinker_structures");
    public static final RegistryObject<BlockStateProviderType<SupplierBlockStateProvider>> supplierBlockstateProvider = BLOCK_STATE_PROVIDER_TYPES.register("supplier_state_provider", () -> new BlockStateProviderType(SupplierBlockStateProvider.CODEC));
    public static final RegistryObject<SlimeTreeFeature> slimeTree = FEATURES.register("slime_tree", () -> new SlimeTreeFeature(SlimeTreeConfig.CODEC));
    public static final RegistryObject<SlimeFungusFeature> slimeFungus = FEATURES.register("slime_fungus", () -> new SlimeFungusFeature(SlimeFungusConfig.CODEC));
    public static ConfiguredFeature<SlimeTreeConfig, ?> earthSlimeTree;
    public static ConfiguredFeature<SlimeTreeConfig, ?> earthSlimeIslandTree;
    public static ConfiguredFeature<SlimeTreeConfig, ?> skySlimeTree;
    public static ConfiguredFeature<SlimeTreeConfig, ?> skySlimeIslandTree;
    public static ConfiguredFeature<SlimeTreeConfig, ?> enderSlimeTree;
    public static ConfiguredFeature<SlimeTreeConfig, ?> enderSlimeIslandTree;
    public static ConfiguredFeature<HugeFungusConfiguration, ?> bloodSlimeFungus;
    public static ConfiguredFeature<HugeFungusConfiguration, ?> bloodSlimeIslandFungus;
    public static ConfiguredFeature<HugeFungusConfiguration, ?> ichorSlimeFungus;
    public static StructurePieceType slimeIslandPiece;
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> earthSlimeIsland;
    public static ConfiguredStructureFeature<NoneFeatureConfiguration, ? extends StructureFeature<NoneFeatureConfiguration>> configuredEarthSlimeIsland;
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> skySlimeIsland;
    public static ConfiguredStructureFeature<NoneFeatureConfiguration, ? extends StructureFeature<NoneFeatureConfiguration>> configuredSkySlimeIsland;
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> clayIsland;
    public static ConfiguredStructureFeature<NoneFeatureConfiguration, ? extends StructureFeature<NoneFeatureConfiguration>> configuredClayIsland;
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> bloodIsland;
    public static ConfiguredStructureFeature<NoneFeatureConfiguration, ? extends StructureFeature<NoneFeatureConfiguration>> configuredBloodIsland;
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> endSlimeIsland;
    public static ConfiguredStructureFeature<NoneFeatureConfiguration, ? extends StructureFeature<NoneFeatureConfiguration>> configuredEndSlimeIsland;

    @SubscribeEvent
    void onFeaturesRegistry(RegistryEvent.Register<StructureFeature<?>> event) {
        slimeIslandPiece = (StructurePieceType)Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)TinkerStructures.resource("slime_island_piece"), SlimeIslandPiece::new);
    }

    private static void addStructureSettings(ImmutableMap.Builder<StructureFeature<?>, StructureFeatureConfiguration> defaultSettings, StructureFeature<?> structure, StructureFeatureConfiguration settings) {
        defaultSettings.put(structure, (Object)settings);
        for (NoiseGeneratorSettings dimensionSettings : BuiltinRegistries.f_123866_) {
            dimensionSettings.m_64457_().m_64590_().put(structure, settings);
        }
    }

    private static void removeStructureSettings(StructureFeature<?> structure) {
        for (NoiseGeneratorSettings dimensionSettings : BuiltinRegistries.f_123866_) {
            dimensionSettings.m_64457_().m_64590_().remove(structure);
        }
    }

    static void addStructures() {
        ImmutableMultimap<ConfiguredStructureFeature<NoneFeatureConfiguration, ? extends StructureFeature<NoneFeatureConfiguration>>, ResourceKey> clayIslandMap = TinkerStructures.multimapOf(configuredClayIsland, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD).stream().filter(biome -> BiomeDictionary.hasType((ResourceKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)).toList());
        ImmutableMultimap skyIslandMap = TinkerStructures.multimapOf(configuredSkySlimeIsland, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD));
        ImmutableMultimap<ConfiguredStructureFeature<NoneFeatureConfiguration, ? extends StructureFeature<NoneFeatureConfiguration>>, ResourceKey> earthIslandMap = TinkerStructures.multimapOf(configuredEarthSlimeIsland, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD).stream().filter(biome -> BiomeDictionary.hasType((ResourceKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)).toList());
        ImmutableMultimap bloodIslandMap = TinkerStructures.multimapOf(configuredBloodIsland, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER));
        ImmutableMultimap<ConfiguredStructureFeature<NoneFeatureConfiguration, ? extends StructureFeature<NoneFeatureConfiguration>>, ResourceKey> endIslandMap = TinkerStructures.multimapOf(configuredEndSlimeIsland, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END).stream().filter(key -> key != Biomes.f_48210_).toList());
        for (NoiseGeneratorSettings dimensionSettings : BuiltinRegistries.f_123866_) {
            StructureSettings settings = dimensionSettings.m_64457_();
            if (settings.f_189361_.containsKey((Object)skySlimeIsland.get())) continue;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.putAll((Map)settings.f_189361_);
            builder.put((Object)((StructureFeature)clayIsland.get()), clayIslandMap);
            builder.put((Object)((StructureFeature)skySlimeIsland.get()), skyIslandMap);
            builder.put((Object)((StructureFeature)earthSlimeIsland.get()), earthIslandMap);
            builder.put((Object)((StructureFeature)bloodIsland.get()), bloodIslandMap);
            builder.put((Object)((StructureFeature)endSlimeIsland.get()), endIslandMap);
            settings.f_189361_ = builder.build();
        }
    }

    private static void addStructureToMap(StructureFeature<?> structure) {
        StructureFeature.f_67012_.put((Object)Objects.requireNonNull(structure.getRegistryName()).toString(), structure);
    }

    public static void addStructureSeparation() {
        if (!structureSettingsReady) {
            return;
        }
        ImmutableMap.Builder defaultSettings = ImmutableMap.builder();
        HashSet ignore = Sets.newHashSet((Object[])new StructureFeature[]{(StructureFeature)earthSlimeIsland.get(), (StructureFeature)skySlimeIsland.get(), (StructureFeature)clayIsland.get(), (StructureFeature)bloodIsland.get(), (StructureFeature)endSlimeIsland.get()});
        defaultSettings.putAll((Iterable)StructureSettings.f_64580_.entrySet().stream().filter(entry -> !ignore.contains(entry.getKey())).collect(Collectors.toList()));
        if (Config.COMMON.earthslimeIslands.doesGenerate()) {
            TinkerStructures.addStructureSettings(defaultSettings, (StructureFeature)earthSlimeIsland.get(), Config.COMMON.earthslimeIslands.makeConfiguration());
        } else {
            TinkerStructures.removeStructureSettings((StructureFeature)earthSlimeIsland.get());
        }
        if (Config.COMMON.skyslimeIslands.doesGenerate()) {
            TinkerStructures.addStructureSettings(defaultSettings, (StructureFeature)skySlimeIsland.get(), Config.COMMON.skyslimeIslands.makeConfiguration());
        } else {
            TinkerStructures.removeStructureSettings((StructureFeature)skySlimeIsland.get());
        }
        if (Config.COMMON.clayIslands.doesGenerate()) {
            TinkerStructures.addStructureSettings(defaultSettings, (StructureFeature)clayIsland.get(), Config.COMMON.clayIslands.makeConfiguration());
        } else {
            TinkerStructures.removeStructureSettings((StructureFeature)clayIsland.get());
        }
        if (Config.COMMON.bloodIslands.doesGenerate()) {
            TinkerStructures.addStructureSettings(defaultSettings, (StructureFeature)bloodIsland.get(), Config.COMMON.bloodIslands.makeConfiguration());
        } else {
            TinkerStructures.removeStructureSettings((StructureFeature)bloodIsland.get());
        }
        if (Config.COMMON.endslimeIslands.doesGenerate()) {
            TinkerStructures.addStructureSettings(defaultSettings, (StructureFeature)endSlimeIsland.get(), Config.COMMON.endslimeIslands.makeConfiguration());
        } else {
            TinkerStructures.removeStructureSettings((StructureFeature)endSlimeIsland.get());
        }
        StructureSettings.f_64580_ = defaultSettings.build();
    }

    private static <K, V> ImmutableMultimap<K, V> multimapOf(K key, Collection<V> values) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(key, values);
        return builder.build();
    }

    @SubscribeEvent
    void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            TinkerStructures.addStructureToMap((StructureFeature)earthSlimeIsland.get());
            TinkerStructures.addStructureToMap((StructureFeature)skySlimeIsland.get());
            TinkerStructures.addStructureToMap((StructureFeature)clayIsland.get());
            TinkerStructures.addStructureToMap((StructureFeature)bloodIsland.get());
            TinkerStructures.addStructureToMap((StructureFeature)endSlimeIsland.get());
        });
        structureSettingsReady = true;
        event.enqueueWork(TinkerStructures::addStructureSeparation);
        event.enqueueWork(() -> {
            configuredEarthSlimeIsland = (ConfiguredStructureFeature)BuiltinRegistries.m_123880_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)TinkerStructures.resource("earth_slime_island"), (Object)((StructureFeature)earthSlimeIsland.get()).m_67065_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
            configuredSkySlimeIsland = (ConfiguredStructureFeature)BuiltinRegistries.m_123880_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)TinkerStructures.resource("sky_slime_island"), (Object)((StructureFeature)skySlimeIsland.get()).m_67065_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
            configuredClayIsland = (ConfiguredStructureFeature)BuiltinRegistries.m_123880_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)TinkerStructures.resource("clay_island"), (Object)((StructureFeature)clayIsland.get()).m_67065_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
            configuredBloodIsland = (ConfiguredStructureFeature)BuiltinRegistries.m_123880_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)TinkerStructures.resource("blood_island"), (Object)((StructureFeature)bloodIsland.get()).m_67065_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
            configuredEndSlimeIsland = (ConfiguredStructureFeature)BuiltinRegistries.m_123880_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)TinkerStructures.resource("end_slime_island"), (Object)((StructureFeature)endSlimeIsland.get()).m_67065_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
            earthSlimeTree = (ConfiguredFeature)Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)TinkerStructures.resource("earth_slime_tree"), (Object)((SlimeTreeFeature)slimeTree.get()).m_65815_(new SlimeTreeConfig.Builder().planted().trunk(() -> TinkerWorld.greenheart.getLog().m_49966_()).leaves(() -> ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.EARTH)).m_49966_()).baseHeight(4).randomHeight(3).build()));
            earthSlimeIslandTree = (ConfiguredFeature)Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)TinkerStructures.resource("earth_slime_island_tree"), (Object)((SlimeTreeFeature)slimeTree.get()).m_65815_(new SlimeTreeConfig.Builder().trunk(() -> TinkerWorld.greenheart.getLog().m_49966_()).leaves(() -> ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.EARTH)).m_49966_()).baseHeight(4).randomHeight(3).build()));
            skySlimeTree = (ConfiguredFeature)Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)TinkerStructures.resource("sky_slime_tree"), (Object)((SlimeTreeFeature)slimeTree.get()).m_65815_(new SlimeTreeConfig.Builder().planted().canDoubleHeight().trunk(() -> TinkerWorld.skyroot.getLog().m_49966_()).leaves(() -> ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.SKY)).m_49966_()).build()));
            skySlimeIslandTree = (ConfiguredFeature)Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)TinkerStructures.resource("sky_slime_island_tree"), (Object)((SlimeTreeFeature)slimeTree.get()).m_65815_(new SlimeTreeConfig.Builder().canDoubleHeight().trunk(() -> TinkerWorld.skyroot.getLog().m_49966_()).leaves(() -> ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.SKY)).m_49966_()).vines(() -> (BlockState)((SlimeVineBlock)TinkerWorld.skySlimeVine.get()).m_49966_().m_61124_(SlimeVineBlock.STAGE, (Comparable)((Object)SlimeVineBlock.VineStage.MIDDLE))).build()));
            enderSlimeTree = (ConfiguredFeature)Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)TinkerStructures.resource("ender_slime_tree"), (Object)((SlimeTreeFeature)slimeTree.get()).m_65815_(new SlimeTreeConfig.Builder().planted().trunk(() -> TinkerWorld.greenheart.getLog().m_49966_()).leaves(() -> ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.ENDER)).m_49966_()).build()));
            enderSlimeIslandTree = (ConfiguredFeature)Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)TinkerStructures.resource("ender_slime_island_tree"), (Object)((SlimeTreeFeature)slimeTree.get()).m_65815_(new SlimeTreeConfig.Builder().trunk(() -> TinkerWorld.greenheart.getLog().m_49966_()).leaves(() -> ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.ENDER)).m_49966_()).vines(() -> (BlockState)((SlimeVineBlock)TinkerWorld.enderSlimeVine.get()).m_49966_().m_61124_(SlimeVineBlock.STAGE, (Comparable)((Object)SlimeVineBlock.VineStage.MIDDLE))).build()));
            bloodSlimeFungus = (ConfiguredFeature)Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)TinkerStructures.resource("blood_slime_fungus"), (Object)((SlimeFungusFeature)slimeFungus.get()).m_65815_((FeatureConfiguration)new SlimeFungusConfig((Tag<Block>)TinkerTags.Blocks.SLIMY_SOIL, TinkerWorld.bloodshroom.getLog().m_49966_(), ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.BLOOD)).m_49966_(), ((CongealedSlimeBlock)TinkerWorld.congealedSlime.get((Enum)SlimeType.ICHOR)).m_49966_(), true)));
            bloodSlimeIslandFungus = (ConfiguredFeature)Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)TinkerStructures.resource("blood_slime_island_fungus"), (Object)((SlimeFungusFeature)slimeFungus.get()).m_65815_((FeatureConfiguration)new SlimeFungusConfig((Tag<Block>)TinkerTags.Blocks.SLIMY_NYLIUM, TinkerWorld.bloodshroom.getLog().m_49966_(), ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.BLOOD)).m_49966_(), ((CongealedSlimeBlock)TinkerWorld.congealedSlime.get((Enum)SlimeType.ICHOR)).m_49966_(), false)));
            ichorSlimeFungus = (ConfiguredFeature)Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)TinkerStructures.resource("ichor_slime_fungus"), (Object)((SlimeFungusFeature)slimeFungus.get()).m_65815_((FeatureConfiguration)new SlimeFungusConfig((Tag<Block>)TinkerTags.Blocks.SLIMY_SOIL, TinkerWorld.bloodshroom.getLog().m_49966_(), ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.ICHOR)).m_49966_(), ((CongealedSlimeBlock)TinkerWorld.congealedSlime.get((Enum)SlimeType.ICHOR)).m_49966_(), false)));
        });
    }

    static {
        earthSlimeIsland = STRUCTURE_FEATURES.register("earth_slime_island", EarthSlimeIslandStructure::new);
        skySlimeIsland = STRUCTURE_FEATURES.register("sky_slime_island", SkySlimeIslandStructure::new);
        clayIsland = STRUCTURE_FEATURES.register("clay_island", ClayIslandStructure::new);
        bloodIsland = STRUCTURE_FEATURES.register("blood_island", BloodSlimeIslandStructure::new);
        endSlimeIsland = STRUCTURE_FEATURES.register("end_slime_island", EnderSlimeIslandStructure::new);
    }
}

