/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.general;

import java.util.Iterator;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.impl.SingleUseModifier;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class SoulboundModifier
extends SingleUseModifier {
    public SoulboundModifier() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::onPlayerDeath);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::onPlayerClone);
    }

    private void onPlayerDeath(LivingDropsEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        if (!entity.m_20193_().m_46469_().m_46207_(GameRules.f_46133_) && entity instanceof Player) {
            Player player = (Player)entity;
            if (!(entity instanceof FakePlayer)) {
                Iterator iter = event.getDrops().iterator();
                Inventory inventory = player.m_150109_();
                while (iter.hasNext()) {
                    ToolStack tool;
                    ItemEntity itemEntity = (ItemEntity)iter.next();
                    ItemStack stack = itemEntity.m_32055_();
                    if (!TinkerTags.Items.MODIFIABLE.m_8110_((Object)stack.m_41720_()) || (tool = ToolStack.from(stack)).getModifierLevel(this) <= 0) continue;
                    inventory.m_36054_(stack);
                    iter.remove();
                }
            }
        }
    }

    private void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        Player original = event.getOriginal();
        Player clone = event.getPlayer();
        if (clone.m_20193_().m_46469_().m_46207_(GameRules.f_46133_) || original.m_5833_()) {
            return;
        }
        Inventory originalInv = original.m_150109_();
        Inventory cloneInv = clone.m_150109_();
        for (int i = 0; i < originalInv.m_6643_(); ++i) {
            ToolStack tool;
            ItemStack stack = originalInv.m_8020_(i);
            if (stack.m_41619_() || !TinkerTags.Items.MODIFIABLE.m_8110_((Object)stack.m_41720_()) || (tool = ToolStack.from(stack)).getModifierLevel(this) <= 0) continue;
            cloneInv.m_36054_(stack);
        }
    }
}

