/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.armor;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.hooks.IArmorWalkModifier;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class SoulSpeedModifier
extends Modifier
implements IArmorWalkModifier {
    private static final UUID ATTRIBUTE_BONUS = UUID.fromString("f61dde72-5b8d-11ec-bf63-0242ac130002");

    private static BlockPos getOnPosition(LivingEntity living) {
        BlockPos below;
        BlockState blockstate;
        int z;
        int y;
        Vec3 position = living.m_20182_();
        int x = Mth.m_14107_((double)position.f_82479_);
        BlockPos pos = new BlockPos(x, y = Mth.m_14107_((double)(position.f_82480_ - (double)0.2f)), z = Mth.m_14107_((double)position.f_82481_));
        if (living.f_19853_.m_46859_(pos) && (blockstate = living.f_19853_.m_8055_(below = pos.m_7495_())).collisionExtendsVertically((BlockGetter)living.f_19853_, below, (Entity)living)) {
            return below;
        }
        return pos;
    }

    @Override
    public void onWalk(IToolStackView tool, int level, LivingEntity living, BlockPos prevPos, BlockPos newPos) {
        if (tool.isBroken() || !living.m_20096_() || living.f_19853_.f_46443_) {
            return;
        }
        AttributeInstance attribute = living.m_21051_(Attributes.f_22279_);
        if (attribute == null) {
            return;
        }
        BlockPos belowPos = SoulSpeedModifier.getOnPosition(living);
        BlockState below = living.f_19853_.m_8055_(belowPos);
        if (below.m_60795_()) {
            return;
        }
        if (attribute.m_22111_(ATTRIBUTE_BONUS) != null) {
            attribute.m_22120_(ATTRIBUTE_BONUS);
        }
        if (!living.m_21255_() && below.m_60620_((Tag)BlockTags.f_13080_)) {
            Random rand = living.m_21187_();
            float boost = 0.03f + (float)level * 0.0105f;
            float speedFactor = below.m_60734_().m_49961_();
            if (speedFactor != 1.0f) {
                boost *= 1.0f / speedFactor;
            }
            attribute.m_22118_(new AttributeModifier(ATTRIBUTE_BONUS, "tconstruct.modifier.soul_speed", (double)boost, AttributeModifier.Operation.ADDITION));
            if (rand.nextFloat() < 0.04f) {
                ToolDamageUtil.damageAnimated(tool, 1, living, EquipmentSlot.FEET);
            }
            Vec3 motion = living.m_20184_();
            if (living.f_19853_ instanceof ServerLevel) {
                ((ServerLevel)living.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123746_, living.m_20185_() + (rand.nextDouble() - 0.5) * (double)living.m_20205_(), living.m_20186_() + 0.1, living.m_20189_() + (rand.nextDouble() - 0.5) * (double)living.m_20205_(), 0, motion.f_82479_ * -0.2, 0.1, motion.f_82481_ * -0.2, 1.0);
            }
            living.f_19853_.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_12404_, living.m_5720_(), rand.nextFloat() * 0.4f + rand.nextFloat() > 0.9f ? 0.6f : 0.0f, 0.6f + rand.nextFloat() * 0.4f);
        }
    }

    @Override
    public void onUnequip(IToolStackView tool, int level, EquipmentChangeContext context) {
        AttributeInstance attribute;
        IToolStackView newTool;
        LivingEntity livingEntity = context.getEntity();
        if (!livingEntity.f_19853_.f_46443_ && context.getChangedSlot() == EquipmentSlot.FEET && ((newTool = context.getReplacementTool()) == null || newTool.isBroken() || newTool.getModifierLevel(this) != level) && (attribute = livingEntity.m_21051_(Attributes.f_22279_)) != null && attribute.m_22111_(ATTRIBUTE_BONUS) != null) {
            attribute.m_22120_(ATTRIBUTE_BONUS);
        }
    }

    @Override
    @Nullable
    public <T> T getModule(Class<T> type) {
        return SoulSpeedModifier.tryModuleMatch(type, IArmorWalkModifier.class, this);
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        if (player == null || key != TooltipKey.SHIFT || !player.m_21255_() && player.f_19853_.m_8055_(SoulSpeedModifier.getOnPosition((LivingEntity)player)).m_60620_((Tag)BlockTags.f_13080_)) {
            this.addPercentTooltip(this.getDisplayName(), 0.3f + (float)level * 0.105f, tooltip);
        }
    }
}

