/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.armor;

import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.impl.IncrementalArmorLevelModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;

public class LeapingModifier
extends IncrementalArmorLevelModifier {
    private static final TinkerDataCapability.TinkerDataKey<Float> LEAPING = TConstruct.createKey("leaping");

    public LeapingModifier() {
        super(LEAPING);
        MinecraftForge.EVENT_BUS.addListener(LeapingModifier::onLivingFall);
        MinecraftForge.EVENT_BUS.addListener(LeapingModifier::onLivingJump);
    }

    private static void onLivingFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntityLiving();
        float boost = ModifierUtil.getTotalModifierFloat(entity, LEAPING);
        if (boost > 0.0f) {
            event.setDistance(Math.max(event.getDistance() - boost, 0.0f));
        }
    }

    private static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntityLiving();
        float boost = ModifierUtil.getTotalModifierFloat(entity, LEAPING);
        if (boost > 0.0f) {
            entity.m_20256_(entity.m_20184_().m_82520_(0.0, (double)boost * 0.1, 0.0));
        }
    }
}

