/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.skull;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.impl.SingleUseModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class MobDisguiseModifier
extends SingleUseModifier {
    public static final TinkerDataCapability.TinkerDataKey<Multiset<EntityType<?>>> DISGUISES = TConstruct.createKey("mob_disguise");
    private final EntityType<?> type;

    @Override
    public void onEquip(IToolStackView tool, int level, EquipmentChangeContext context) {
        if (context.getChangedSlot().m_20743_() == EquipmentSlot.Type.ARMOR) {
            context.getTinkerData().ifPresent(data -> {
                HashMultiset disguises = data.get(DISGUISES);
                if (disguises == null) {
                    disguises = HashMultiset.create();
                    data.put(DISGUISES, disguises);
                }
                disguises.add(this.type);
            });
        }
    }

    @Override
    public void onUnequip(IToolStackView tool, int level, EquipmentChangeContext context) {
        if (context.getChangedSlot().m_20743_() == EquipmentSlot.Type.ARMOR) {
            context.getTinkerData().ifPresent(data -> {
                Multiset<EntityType<?>> disguises = data.get(DISGUISES);
                if (disguises != null) {
                    disguises.remove(this.type);
                }
            });
        }
    }

    public MobDisguiseModifier(EntityType<?> type) {
        this.type = type;
    }
}

