/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.melee;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.impl.TankModifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class SearingModifier
extends Modifier {
    private static final float BASELINE_TEMPERATURE = 0.75f;

    @Override
    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        ((TankModifier)TinkerModifiers.tank.get()).addCapacity(volatileData, 250);
    }

    private static float temperatureBoost(LivingEntity living, int level) {
        BlockPos attackerPos = living.m_142538_();
        return (living.f_19853_.m_46857_(attackerPos).m_47505_(attackerPos) - 0.75f) * (float)(level * 2);
    }

    @Override
    public float getEntityDamage(IToolStackView tool, int level, ToolAttackContext context, float baseDamage, float damage) {
        return damage + SearingModifier.temperatureBoost(context.getAttacker(), level) * tool.getMultiplier(ToolStats.ATTACK_DAMAGE);
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        float bonus = player != null && tooltipKey == TooltipKey.SHIFT ? SearingModifier.temperatureBoost((LivingEntity)player, level) : (float)level * 2.5f;
        this.addDamageTooltip(tool, bonus, tooltip);
    }
}

