/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.melee;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.tags.Tag;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.library.utils.Util;

public class ConductingModifier
extends Modifier {
    private static final Component ATTACK_DAMAGE = TConstruct.makeTranslation("modifier", "conducting.attack_damage");
    private static final int MAX_BONUS_TICKS = 300;
    private static final float PERCENT_PER_LEVEL = 0.15f;

    @Override
    public int getPriority() {
        return 90;
    }

    private static float getBonus(LivingEntity living, int level) {
        int fire = living.m_20094_();
        if (fire > 0) {
            float bonus = 0.15f * (float)level;
            if (fire < 300) {
                bonus *= (float)fire / 300.0f;
            }
            if (living.m_21023_(MobEffects.f_19607_)) {
                bonus /= 2.0f;
            }
            return bonus;
        }
        return 0.0f;
    }

    @Override
    public float getEntityDamage(IToolStackView tool, int level, ToolAttackContext context, float baseDamage, float damage) {
        float bonus = ConductingModifier.getBonus(context.getAttacker(), level);
        if (bonus > 0.0f) {
            damage *= 1.0f + bonus;
        }
        return damage;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        if (tool.hasTag((Tag<Item>)TinkerTags.Items.MELEE_OR_UNARMED)) {
            float bonus = 0.15f * (float)level;
            if (player != null && key == TooltipKey.SHIFT && player.m_20094_() == 0) {
                bonus = 0.0f;
            }
            tooltip.add((Component)this.applyStyle(new TextComponent(Util.PERCENT_BOOST_FORMAT.format(bonus) + " ").m_7220_(ATTACK_DAMAGE)));
        }
    }
}

