/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.harvest;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class MaintainedModifier
extends Modifier {
    private static final Component MINING_SPEED = TConstruct.makeTranslation("modifier", "maintained.mining_speed");
    private static final ResourceLocation KEY_ORIGINAL_DURABILITY = TConstruct.getResource("durability");

    @Override
    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        volatileData.putInt(KEY_ORIGINAL_DURABILITY, (int)(context.getBaseStats().get(ToolStats.DURABILITY).floatValue() * context.getDefinition().getData().getMultiplier(ToolStats.DURABILITY)));
    }

    public static float boost(int durability, float boost, int min, int max) {
        if (durability > min) {
            if (durability > max) {
                return boost;
            }
            return boost * (float)(durability - min) / (float)(max - min);
        }
        return 0.0f;
    }

    protected float getTotalBoost(IToolStackView tool, int level) {
        int durability = tool.getCurrentDurability();
        int baseMax = tool.getVolatileData().getInt(KEY_ORIGINAL_DURABILITY);
        float boost = MaintainedModifier.boost(durability, 0.1f, baseMax / 2, baseMax);
        int fullMax = tool.getStats().getInt(ToolStats.DURABILITY);
        if (fullMax > baseMax) {
            boost += MaintainedModifier.boost(durability, 0.05f, baseMax, Math.max(baseMax * 2, fullMax));
        }
        return boost * (float)level;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        double boost;
        if (tool.hasTag((Tag<Item>)TinkerTags.Items.HARVEST) && (boost = (double)this.getTotalBoost(tool, level)) != 0.0) {
            this.addPercentTooltip(MINING_SPEED, boost, tooltip);
        }
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (isEffective) {
            event.setNewSpeed(event.getNewSpeed() * (1.0f + this.getTotalBoost(tool, level)));
        }
    }
}

