/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.slotless;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.impl.DurabilityShieldModifier;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class OverslimeModifier
extends DurabilityShieldModifier {
    private static final ResourceLocation KEY_OVERSLIME_CAP = TConstruct.getResource("overslime_cap");
    private static final ResourceLocation KEY_OVERSLIME_FRIEND = TConstruct.getResource("overslime_friend");

    @Override
    public Component getDisplayName(int level) {
        return super.getDisplayName();
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        this.addCapacity(volatileData, (int)(50.0f * context.getDefinition().getData().getMultiplier(ToolStats.DURABILITY)));
    }

    @Override
    public void addToolStats(ToolRebuildContext context, int level, ModifierStatsBuilder builder) {
        if (!context.getVolatileData().getBoolean(KEY_OVERSLIME_FRIEND)) {
            ToolStats.ATTACK_DAMAGE.multiply(builder, 0.9f);
            ToolStats.MINING_SPEED.multiply(builder, 0.9f);
        }
    }

    @Override
    public int getPriority() {
        return 150;
    }

    @Override
    @Nullable
    public Boolean showDurabilityBar(IToolStackView tool, int level) {
        return this.getOverslime(tool) < this.getCapacity(tool);
    }

    @Override
    public int getDurabilityRGB(IToolStackView tool, int level) {
        if (this.getOverslime(tool) > 0) {
            return 53503;
        }
        return -1;
    }

    @Override
    protected ResourceLocation getShieldKey() {
        return this.getId();
    }

    public ResourceLocation getCapacityKey() {
        return KEY_OVERSLIME_CAP;
    }

    public ResourceLocation getFriendKey() {
        return KEY_OVERSLIME_FRIEND;
    }

    public void setFriend(ModDataNBT volatileData) {
        volatileData.putBoolean(this.getFriendKey(), true);
    }

    public int getCapacity(IModDataView volatileData) {
        return volatileData.getInt(this.getCapacityKey());
    }

    public int getCapacity(IToolStackView tool) {
        return this.getCapacity(tool.getVolatileData());
    }

    @Override
    protected int getShieldCapacity(IToolStackView tool, int level) {
        return this.getCapacity(tool);
    }

    public void setCapacity(ModDataNBT volatileData, int amount) {
        volatileData.putInt(KEY_OVERSLIME_CAP, amount);
    }

    public void addCapacity(ModDataNBT volatileData, int amount) {
        this.setCapacity(volatileData, this.getCapacity(volatileData) + amount);
    }

    public void multiplyCapacity(ModDataNBT volatileData, float factor) {
        volatileData.putInt(KEY_OVERSLIME_CAP, (int)((float)this.getCapacity(volatileData) * factor));
    }

    public int getOverslime(IToolStackView tool) {
        return this.getShield(tool);
    }

    @Override
    public void setShield(ModDataNBT persistentData, int amount) {
        super.setShield(persistentData, amount);
    }

    public void setOverslime(IToolStackView tool, int amount) {
        this.setShield(tool, 0, amount);
    }

    public void addOverslime(IToolStackView tool, int amount) {
        int overworked = tool.getModifierLevel((Modifier)TinkerModifiers.overworked.get());
        this.addShield(tool, 0, amount * (1 + overworked));
    }
}

