/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.impl.IncrementalModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.logic.ModifierMaxLevel;

public abstract class AbstractProtectionModifier<T extends ModifierMaxLevel>
extends IncrementalModifier {
    private final TinkerDataCapability.TinkerDataKey<T> key;

    protected abstract T createData();

    protected void reset(T data) {
    }

    @Override
    public void onUnequip(IToolStackView tool, int level, EquipmentChangeContext context) {
        LivingEntity entity = context.getEntity();
        EquipmentSlot slot = context.getChangedSlot();
        if (slot.m_20743_() == EquipmentSlot.Type.ARMOR && !entity.f_19853_.f_46443_) {
            context.getTinkerData().ifPresent(data -> {
                ModifierMaxLevel modData = (ModifierMaxLevel)data.get(this.key);
                if (modData != null) {
                    modData.set(slot, 0.0f);
                    if (modData.getMax() == 0.0f) {
                        this.reset(modData);
                    }
                }
            });
        }
    }

    @Override
    public void onEquip(IToolStackView tool, int level, EquipmentChangeContext context) {
        LivingEntity entity = context.getEntity();
        EquipmentSlot slot = context.getChangedSlot();
        if (!entity.f_19853_.f_46443_ && slot.m_20743_() == EquipmentSlot.Type.ARMOR && !tool.isBroken()) {
            float scaledLevel = this.getScaledLevel(tool, level);
            context.getTinkerData().ifPresent(data -> {
                ModifierMaxLevel modData = (ModifierMaxLevel)data.get(this.key);
                if (modData == null) {
                    modData = this.createData();
                    data.put(this.key, modData);
                }
                modData.set(slot, scaledLevel);
            });
        }
    }

    public static void addResistanceTooltip(IncrementalModifier modifier, IToolStackView tool, int level, float multiplier, List<Component> tooltip) {
        if (tool.hasTag((Tag<Item>)TinkerTags.Items.ARMOR)) {
            tooltip.add((Component)modifier.applyStyle(new TextComponent(Util.PERCENT_BOOST_FORMAT.format(modifier.getScaledLevel(tool, level) * multiplier / 25.0f)).m_130946_(" ").m_7220_((Component)new TranslatableComponent(modifier.getTranslationKey() + ".resistance"))));
        }
    }

    public AbstractProtectionModifier(TinkerDataCapability.TinkerDataKey<T> key) {
        this.key = key;
    }
}

