/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.tool;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.modifiers.impl.TankModifier;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.SpillingRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.SpillingRecipeLookup;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.particle.FluidParticleData;

public class SpillingModifier
extends TankModifier {
    public SpillingModifier() {
        super(1000);
    }

    private static void spawnParticles(Entity target, FluidStack fluid) {
        if (target.f_19853_ instanceof ServerLevel) {
            ((ServerLevel)target.f_19853_).m_8767_((ParticleOptions)new FluidParticleData((ParticleType<FluidParticleData>)((ParticleType)TinkerCommons.fluidParticle.get()), fluid), target.m_20185_(), target.m_20227_(0.5), target.m_20189_(), 10, 0.1, 0.2, 0.1, 0.2);
        }
    }

    @Override
    public void onAttacked(IToolStackView tool, int level, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        FluidStack fluid;
        Entity attacker = source.m_7639_();
        if (isDirectDamage && attacker != null && RANDOM.nextInt(4) < level && !(fluid = this.getFluid(tool)).isEmpty()) {
            Player p;
            LivingEntity self = context.getEntity();
            Player player = self instanceof Player ? (p = (Player)self) : null;
            SpillingRecipe recipe = SpillingRecipeLookup.findRecipe(self.f_19853_.m_7465_(), fluid.getFluid());
            if (recipe != null) {
                ToolAttackContext attackContext = new ToolAttackContext(self, player, InteractionHand.MAIN_HAND, attacker, attacker instanceof LivingEntity ? (LivingEntity)attacker : null, false, 1.0f, false);
                FluidStack remaining = recipe.applyEffects(fluid, level, attackContext);
                SpillingModifier.spawnParticles(attacker, fluid);
                if (player == null || !player.m_7500_()) {
                    this.setFluid(tool, remaining);
                }
            }
        }
    }

    @Override
    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        SpillingRecipe recipe;
        FluidStack fluid;
        if (damageDealt > 0.0f && context.isFullyCharged() && !(fluid = this.getFluid(tool)).isEmpty() && (recipe = SpillingRecipeLookup.findRecipe(context.getAttacker().f_19853_.m_7465_(), fluid.getFluid())) != null) {
            FluidStack remaining = recipe.applyEffects(fluid, level, context);
            SpillingModifier.spawnParticles(context.getTarget(), fluid);
            Player player = context.getPlayerAttacker();
            if (player == null || !player.m_7500_()) {
                this.setFluid(tool, remaining);
            }
        }
        return 0;
    }
}

