/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.armor.walker;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.ToolAction;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.ability.armor.walker.AbstractWalkerModifier;

public class BlockTransformWalkerModifier
extends AbstractWalkerModifier {
    private final ToolAction action;
    private final SoundEvent sound;

    @Override
    protected float getRadius(IToolStackView tool, int level) {
        return 1.5f + (float)tool.getModifierLevel((Modifier)TinkerModifiers.expanded.get());
    }

    @Override
    public boolean canPerformAction(IToolStackView tool, int level, ToolAction toolAction) {
        return toolAction == this.action;
    }

    @Override
    public void onWalk(IToolStackView tool, int level, LivingEntity living, BlockPos prevPos, BlockPos newPos) {
        if (living instanceof Player) {
            super.onWalk(tool, level, living, prevPos, newPos);
        }
    }

    @Override
    protected void walkOn(IToolStackView tool, int level, LivingEntity living, Level world, BlockPos target, BlockPos.MutableBlockPos mutable) {
        Material material = world.m_8055_(target).m_60767_();
        if (material.m_76336_() || material == Material.f_76300_) {
            mutable.m_122178_(target.m_123341_(), target.m_123342_() - 1, target.m_123343_());
            BlockState original = world.m_8055_((BlockPos)mutable);
            BlockState transformed = original.getToolModifiedState(world, (BlockPos)mutable, (Player)living, living.m_6844_(EquipmentSlot.FEET), this.action);
            if (transformed != null) {
                world.m_7731_((BlockPos)mutable, transformed, 11);
                world.m_46961_(target, true);
                world.m_5594_(null, (BlockPos)mutable, this.sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                ToolDamageUtil.damageAnimated(tool, 1, living, EquipmentSlot.FEET);
            }
        }
    }

    public BlockTransformWalkerModifier(ToolAction action, SoundEvent sound) {
        this.action = action;
        this.sound = sound;
    }
}

