/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.armor;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.hooks.IArmorInteractModifier;
import slimeknights.tconstruct.library.modifiers.impl.TankModifier;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.SpillingRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.SpillingRecipeLookup;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.particle.FluidParticleData;

public class SlurpingModifier
extends TankModifier
implements IArmorInteractModifier {
    private static final float DEGREE_TO_RADIANS = (float)Math.PI / 180;
    private static final TinkerDataCapability.TinkerDataKey<SlurpingInfo> SLURP_FINISH_TIME = TConstruct.createKey("slurping_finish");

    public SlurpingModifier() {
        super(1000);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, TickEvent.PlayerTickEvent.class, this::playerTick);
    }

    @Override
    public boolean startArmorInteract(IToolStackView tool, int level, Player player, EquipmentSlot slot) {
        SpillingRecipe recipe;
        FluidStack fluid;
        if (!player.m_6144_() && !(fluid = this.getFluid(tool)).isEmpty() && (recipe = SpillingRecipeLookup.findRecipe(player.m_20193_().m_7465_(), fluid.getFluid())) != null) {
            player.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> data.put(SLURP_FINISH_TIME, new SlurpingInfo(fluid, player.f_19797_ + 20)));
            return true;
        }
        return false;
    }

    private static void addFluidParticles(Player player, FluidStack fluid, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 motion = new Vec3(((double)RANDOM.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            motion = motion.m_82496_(-player.m_146909_() * ((float)Math.PI / 180));
            motion = motion.m_82524_(-player.m_146908_() * ((float)Math.PI / 180));
            Vec3 position = new Vec3(((double)RANDOM.nextFloat() - 0.5) * 0.3, (double)(-RANDOM.nextFloat()) * 0.6 - 0.3, 0.6);
            position = position.m_82496_(-player.m_146909_() * ((float)Math.PI / 180));
            position = position.m_82524_(-player.m_146908_() * ((float)Math.PI / 180));
            position = position.m_82520_(player.m_20185_(), player.m_20188_(), player.m_20189_());
            FluidParticleData data = new FluidParticleData((ParticleType<FluidParticleData>)((ParticleType)TinkerCommons.fluidParticle.get()), fluid);
            if (player.f_19853_ instanceof ServerLevel) {
                ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)data, position.f_82479_, position.f_82480_, position.f_82481_, 1, motion.f_82479_, motion.f_82480_ + 0.05, motion.f_82481_, 0.0);
                continue;
            }
            player.f_19853_.m_7106_((ParticleOptions)data, position.f_82479_, position.f_82480_, position.f_82481_, motion.f_82479_, motion.f_82480_ + 0.05, motion.f_82481_);
        }
    }

    private void playerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.m_5833_()) {
            return;
        }
        player.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
            SlurpingInfo info = data.get(SLURP_FINISH_TIME);
            if (info != null) {
                int timeLeft = info.finishTime - player.f_19797_;
                if (timeLeft < 0) {
                    SpillingRecipe recipe;
                    ToolStack tool;
                    FluidStack fluid;
                    player.m_5496_(SoundEvents.f_11911_, 0.5f, RANDOM.nextFloat() * 0.1f + 0.9f);
                    SlurpingModifier.addFluidParticles(player, info.fluid, 16);
                    if (!player.m_20193_().f_46443_ && !(fluid = this.getFluid(tool = ToolStack.from(player.m_6844_(EquipmentSlot.HEAD)))).isEmpty() && (recipe = SpillingRecipeLookup.findRecipe(player.m_20193_().m_7465_(), fluid.getFluid())) != null) {
                        ToolAttackContext context = new ToolAttackContext((LivingEntity)player, player, InteractionHand.MAIN_HAND, (Entity)player, (LivingEntity)player, false, 1.0f, false);
                        FluidStack remaining = recipe.applyEffects(fluid, tool.getModifierLevel(this), context);
                        if (!player.m_7500_()) {
                            this.setFluid(tool, remaining);
                        }
                    }
                    data.remove(SLURP_FINISH_TIME);
                } else if (timeLeft % 4 == 0) {
                    player.m_5496_(SoundEvents.f_11911_, 0.5f, RANDOM.nextFloat() * 0.1f + 0.9f);
                    SlurpingModifier.addFluidParticles(player, info.fluid, 5);
                }
            }
        });
    }

    @Override
    public void stopArmorInteract(IToolStackView tool, int level, Player player, EquipmentSlot slot) {
        player.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> data.remove(SLURP_FINISH_TIME));
    }

    @Override
    @Nullable
    public <T> T getModule(Class<T> type) {
        if (type == IArmorInteractModifier.class) {
            return (T)this;
        }
        return super.getModule(type);
    }

    private record SlurpingInfo(FluidStack fluid, int finishTime) {
    }
}

