/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.utils.Util;

public class CreativeSlotItem
extends Item {
    private static final String NBT_KEY = "slot";
    private static final String TOOLTIP = TConstruct.makeTranslationKey("item", "creative_slot.tooltip");
    private static final Component TOOLTIP_MISSING = TConstruct.makeTranslation("item", "creative_slot.missing").m_130940_(ChatFormatting.RED);

    public CreativeSlotItem(Item.Properties properties) {
        super(properties);
    }

    @Nullable
    public static SlotType getSlot(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128425_(NBT_KEY, 8)) {
            return SlotType.getIfPresent(nbt.m_128461_(NBT_KEY));
        }
        return null;
    }

    public static ItemStack withSlot(ItemStack stack, SlotType type) {
        stack.m_41784_().m_128359_(NBT_KEY, type.getName());
        return stack;
    }

    public String m_5671_(ItemStack stack) {
        String betterKey;
        SlotType slot = CreativeSlotItem.getSlot(stack);
        String originalKey = this.m_5524_();
        if (slot != null && Util.canTranslate(betterKey = originalKey + "." + slot.getName())) {
            return betterKey;
        }
        return originalKey;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        SlotType slot = CreativeSlotItem.getSlot(stack);
        if (slot != null) {
            tooltip.add((Component)new TranslatableComponent(TOOLTIP, new Object[]{slot.getDisplayName()}).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add(TOOLTIP_MISSING);
        }
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            Collection<SlotType> allTypes = SlotType.getAllSlotTypes();
            if (allTypes.isEmpty()) {
                items.add((Object)new ItemStack((ItemLike)this));
            } else {
                for (SlotType type : allTypes) {
                    items.add((Object)CreativeSlotItem.withSlot(new ItemStack((ItemLike)this), type));
                }
            }
        }
    }
}

