/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import slimeknights.tconstruct.library.tools.layout.LayoutSlot;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayout;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayoutLoader;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.block.entity.table.TinkerStationBlockEntity;
import slimeknights.tconstruct.tables.menu.TabbedContainerMenu;
import slimeknights.tconstruct.tables.menu.slot.LazyResultSlot;
import slimeknights.tconstruct.tables.menu.slot.TinkerStationSlot;
import slimeknights.tconstruct.tools.item.ArmorSlotType;

public class TinkerStationContainerMenu
extends TabbedContainerMenu<TinkerStationBlockEntity> {
    private static final ResourceLocation[] ARMOR_SLOT_BACKGROUNDS = new ResourceLocation[]{InventoryMenu.f_39696_, InventoryMenu.f_39695_, InventoryMenu.f_39694_, InventoryMenu.f_39693_};
    private final List<Slot> inputSlots;
    private final LazyResultSlot resultSlot;

    public TinkerStationContainerMenu(int id, Inventory inv, @Nullable TinkerStationBlockEntity tile) {
        super((MenuType)TinkerTables.tinkerStationContainer.get(), id, inv, tile);
        if (tile != null) {
            tile.syncRecipe(inv.f_35978_);
            this.inputSlots = new ArrayList<Slot>();
            this.inputSlots.add(this.m_38897_(new TinkerStationSlot(tile, 0, 0, 0)));
            for (int index = 0; index < tile.m_6643_() - 1; ++index) {
                this.inputSlots.add(this.m_38897_(new TinkerStationSlot(tile, index + 1, 0, 0)));
            }
            this.resultSlot = new LazyResultSlot(tile.getCraftingResult(), 114, 38);
            this.m_38897_(this.resultSlot);
            this.setToolSelection(StationSlotLayoutLoader.getInstance().get(Objects.requireNonNull(tile.m_58900_().m_60734_().getRegistryName())));
        } else {
            this.resultSlot = null;
            this.inputSlots = Collections.emptyList();
        }
        for (ArmorSlotType slotType : ArmorSlotType.values()) {
            int index = slotType.getIndex();
            this.m_38897_(new ArmorSlot(inv, slotType.getEquipmentSlot(), 152, 16 + (3 - index) * 18));
        }
        this.m_38897_(new Slot((Container)inv, 40, 132, 70).setBackground(InventoryMenu.f_39692_, InventoryMenu.f_39697_));
        this.addInventorySlots();
    }

    public TinkerStationContainerMenu(int id, Inventory inv, FriendlyByteBuf buf) {
        this(id, inv, (TinkerStationBlockEntity)TinkerStationContainerMenu.getTileEntityFromBuf((FriendlyByteBuf)buf, TinkerStationBlockEntity.class));
    }

    protected int getInventoryYOffset() {
        return 92;
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot != this.resultSlot && super.m_5882_(stack, slot);
    }

    public void setToolSelection(StationSlotLayout layout) {
        assert (this.tile != null);
        int maxSize = ((TinkerStationBlockEntity)this.tile).m_6643_();
        for (int i = 0; i < maxSize; ++i) {
            Slot slot = (Slot)this.f_38839_.get(i);
            if (!(slot instanceof TinkerStationSlot)) continue;
            TinkerStationSlot slotToolPart = (TinkerStationSlot)slot;
            LayoutSlot layoutSlot = layout.getSlot(i);
            if (layoutSlot.isHidden()) {
                slotToolPart.deactivate();
                continue;
            }
            slotToolPart.activate(layoutSlot);
        }
    }

    public ItemStack getResult() {
        return this.resultSlot.m_7993_();
    }

    public List<Slot> getInputSlots() {
        return this.inputSlots;
    }

    private static class ArmorSlot
    extends Slot {
        private final Player player;
        private final EquipmentSlot slotType;

        public ArmorSlot(Inventory inv, EquipmentSlot slotType, int xPosition, int yPosition) {
            super((Container)inv, 36 + slotType.m_20749_(), xPosition, yPosition);
            this.player = inv.f_35978_;
            this.slotType = slotType;
            this.setBackground(InventoryMenu.f_39692_, ARMOR_SLOT_BACKGROUNDS[slotType.m_20749_()]);
        }

        public int m_6641_() {
            return 1;
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.canEquip(this.slotType, (Entity)this.player);
        }

        public boolean m_8010_(Player player) {
            ItemStack stack = this.m_7993_();
            return stack.m_41619_() || player.m_7500_() || !EnchantmentHelper.m_44920_((ItemStack)stack);
        }
    }
}

