/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.menu;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import slimeknights.mantle.inventory.SmartItemHandlerSlot;
import slimeknights.mantle.util.sync.ValidZeroDataSlot;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.shared.inventory.TriggeringBaseContainerMenu;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.entity.controller.AlloyerBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.module.alloying.MixerAlloyTank;

public class AlloyerContainerMenu
extends TriggeringBaseContainerMenu<AlloyerBlockEntity> {
    private boolean hasFuelSlot = false;

    public AlloyerContainerMenu(int id, @Nullable Inventory inv, @Nullable AlloyerBlockEntity alloyer) {
        super((MenuType)TinkerSmeltery.alloyerContainer.get(), id, inv, alloyer);
        if (alloyer != null) {
            BlockEntity te;
            Level world = alloyer.m_58904_();
            if (world != null && world.f_46443_) {
                MixerAlloyTank alloyTank = alloyer.getAlloyTank();
                for (Direction direction : Direction.values()) {
                    if (direction == Direction.DOWN) continue;
                    alloyTank.refresh(direction, true);
                }
            }
            BlockPos down = alloyer.m_58899_().m_7495_();
            if (world != null && world.m_8055_(down).m_60620_(TinkerTags.Blocks.FUEL_TANKS) && (te = world.m_7702_(down)) != null) {
                this.hasFuelSlot = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(handler -> {
                    this.m_38897_((Slot)new SmartItemHandlerSlot(handler, 0, 151, 32));
                    return true;
                }).isPresent();
            }
            this.addInventorySlots();
            Consumer<DataSlot> referenceConsumer = x$0 -> this.m_38895_((DataSlot)x$0);
            ValidZeroDataSlot.trackIntArray(referenceConsumer, (ContainerData)alloyer.getFuelModule());
        }
    }

    public AlloyerContainerMenu(int id, Inventory inv, FriendlyByteBuf buf) {
        this(id, inv, (AlloyerBlockEntity)AlloyerContainerMenu.getTileEntityFromBuf((FriendlyByteBuf)buf, AlloyerBlockEntity.class));
    }

    public boolean isHasFuelSlot() {
        return this.hasFuelSlot;
    }
}

