/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import slimeknights.mantle.item.BlockTooltipItem;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.fluid.FluidTooltipHandler;
import slimeknights.tconstruct.library.utils.SafeClientAccess;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.smeltery.block.entity.component.TankBlockEntity;
import slimeknights.tconstruct.smeltery.item.TankItemFluidHandler;

public class TankItem
extends BlockTooltipItem {
    private static final String KEY_FLUID = TConstruct.makeTranslationKey("block", "tank.fluid");
    private static final String KEY_MB = TConstruct.makeTranslationKey("block", "tank.mb");
    private static final String KEY_INGOTS = TConstruct.makeTranslationKey("block", "tank.ingots");
    private static final String KEY_MIXED = TConstruct.makeTranslationKey("block", "tank.mixed");
    private final boolean limitStackSize;

    public TankItem(Block blockIn, Item.Properties builder, boolean limitStackSize) {
        super(blockIn, builder);
        this.limitStackSize = limitStackSize;
    }

    private static boolean isFilled(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128425_("tank", 10);
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return TankItem.isFilled(stack) ? new ItemStack((ItemLike)this) : ItemStack.f_41583_;
    }

    public int getItemStackLimit(ItemStack stack) {
        if (!this.limitStackSize) {
            return super.getItemStackLimit(stack);
        }
        return TankItem.isFilled(stack) ? 16 : 64;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41782_()) {
            FluidTank tank = TankItem.getFluidTank(stack);
            if (tank.getFluidAmount() > 0) {
                tooltip.add((Component)new TranslatableComponent(KEY_FLUID, new Object[]{tank.getFluid().getDisplayName()}).m_130940_(ChatFormatting.GRAY));
                int amount = tank.getFluidAmount();
                TooltipKey key = SafeClientAccess.getTooltipKey();
                if (tank.getCapacity() % 90 != 0 || key == TooltipKey.SHIFT) {
                    tooltip.add((Component)new TranslatableComponent(KEY_MB, new Object[]{amount}).m_130940_(ChatFormatting.GRAY));
                } else {
                    int ingots = amount / 90;
                    int mb = amount % 90;
                    if (mb == 0) {
                        tooltip.add((Component)new TranslatableComponent(KEY_INGOTS, new Object[]{ingots}).m_130940_(ChatFormatting.GRAY));
                    } else {
                        tooltip.add((Component)new TranslatableComponent(KEY_MIXED, new Object[]{ingots, mb}).m_130940_(ChatFormatting.GRAY));
                    }
                    if (key != TooltipKey.UNKNOWN) {
                        tooltip.add(FluidTooltipHandler.HOLD_SHIFT);
                    }
                }
            }
        } else {
            super.m_7373_(stack, worldIn, tooltip, flagIn);
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new TankItemFluidHandler(stack);
    }

    public static ItemStack setTank(ItemStack stack, FluidTank tank) {
        if (tank.isEmpty()) {
            CompoundTag nbt = stack.m_41783_();
            if (nbt != null) {
                nbt.m_128473_("tank");
                if (nbt.m_128456_()) {
                    stack.m_41751_(null);
                }
            }
        } else {
            stack.m_41784_().m_128365_("tank", (Tag)tank.writeToNBT(new CompoundTag()));
        }
        return stack;
    }

    public static FluidTank getFluidTank(ItemStack stack) {
        FluidTank tank = new FluidTank(TankBlockEntity.getCapacity(stack.m_41720_()));
        if (stack.m_41782_()) {
            assert (stack.m_41783_() != null);
            tank.readFromNBT(stack.m_41783_().m_128469_("tank"));
        }
        return tank;
    }
}

