/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.multiblock;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.smeltery.block.entity.multiblock.MultiblockResult;
import slimeknights.tconstruct.smeltery.block.entity.multiblock.MultiblockStructureData;

public abstract class MultiblockCuboid<T extends MultiblockStructureData> {
    protected static final MultiblockResult NO_ATTEMPT = MultiblockResult.error(null, (Component)TConstruct.makeTranslation("multiblock", "generic.no_attempt"));
    protected static final MultiblockResult NOT_LOADED = MultiblockResult.error(null, (Component)TConstruct.makeTranslation("multiblock", "generic.not_loaded"));
    protected static final MultiblockResult TOO_HIGH = MultiblockResult.error(null, (Component)TConstruct.makeTranslation("multiblock", "generic.too_high"));
    protected static final Component INVALID_INNER_BLOCK = TConstruct.makeTranslation("multiblock", "generic.invalid_inner_block");
    protected static final String TOO_LARGE = TConstruct.makeTranslationKey("multiblock", "generic.too_large");
    protected static final Component INVALID_FLOOR_BLOCK = TConstruct.makeTranslation("multiblock", "generic.invalid_floor_block");
    protected static final Component INVALID_CEILING_BLOCK = TConstruct.makeTranslation("multiblock", "generic.invalid_floor_block");
    protected static final Component INVALID_WALL_BLOCK = TConstruct.makeTranslation("multiblock", "generic.invalid_wall_block");
    protected static final Component INVALID_FLOOR_FRAME = TConstruct.makeTranslation("multiblock", "generic.invalid_floor_frame");
    protected static final Component INVALID_CEILING_FRAME = TConstruct.makeTranslation("multiblock", "generic.invalid_ceiling_frame");
    protected static final Component INVALID_WALL_FRAME = TConstruct.makeTranslation("multiblock", "generic.invalid_wall_frame");
    private static final int NORTH = Direction.NORTH.m_122416_();
    private static final int EAST = Direction.EAST.m_122416_();
    private static final int SOUTH = Direction.SOUTH.m_122416_();
    private static final int WEST = Direction.WEST.m_122416_();
    protected final boolean hasFloor;
    protected final boolean hasFrame;
    protected final boolean hasCeiling;
    private final int maxHeight;
    private final int innerLimit;
    private MultiblockResult lastResult = NO_ATTEMPT;

    public MultiblockCuboid(boolean hasFloor, boolean hasFrame, boolean hasCeiling) {
        this(hasFloor, hasFrame, hasCeiling, 64, 14);
    }

    @Nullable
    public T detectMultiblock(Level world, BlockPos master, Direction facing) {
        int height;
        MultiblockResult result;
        ImmutableSet.Builder extraBlocks = ImmutableSet.builder();
        BlockPos center = this.getOuterPos(world, master.m_142300_(facing.m_122424_()), Direction.DOWN, this.maxHeight).m_7494_();
        if (!(master.m_123342_() >= center.m_123342_() || this.hasFrame && this.isInnerBlock(world, center))) {
            this.setLastResult(MultiblockResult.error(center.m_7495_(), INVALID_INNER_BLOCK));
            return null;
        }
        int[] edges = new int[4];
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos pos = this.getOuterPos(world, center, direction, this.innerLimit + 1);
            edges[direction.m_122416_()] = pos.m_123341_() - center.m_123341_() + (pos.m_123343_() - center.m_123343_());
        }
        int xd = edges[SOUTH] - edges[NORTH] - 1;
        int zd = edges[EAST] - edges[WEST] - 1;
        if (xd > this.innerLimit || zd > this.innerLimit) {
            this.setLastResult(MultiblockResult.error(null, TOO_LARGE, xd, zd, this.innerLimit, this.innerLimit));
            return null;
        }
        BlockPos from = center.m_142082_(edges[WEST], 0, edges[NORTH]);
        BlockPos to = center.m_142082_(edges[EAST], 0, edges[SOUTH]);
        Consumer<Collection<BlockPos>> posConsumer = arg_0 -> ((ImmutableSet.Builder)extraBlocks).addAll(arg_0);
        if (this.hasFloor && !(result = this.detectCap(world, from.m_7495_(), to.m_7495_(), CuboidSide.FLOOR, posConsumer)).isSuccess()) {
            this.setLastResult(result);
            return null;
        }
        int localMax = Math.min(this.maxHeight, world.m_141928_() - center.m_123342_());
        MultiblockResult heightResult = TOO_HIGH;
        for (height = 0; height < localMax && (heightResult = this.detectLayer(world, from.m_6630_(height), to.m_6630_(height), posConsumer)).isSuccess(); ++height) {
        }
        if (height == 0 || height <= master.m_123342_() - center.m_123342_()) {
            this.setLastResult(heightResult);
            return null;
        }
        if (height == localMax) {
            heightResult = MultiblockResult.SUCCESS;
        }
        if (this.hasCeiling) {
            MultiblockResult result2 = this.detectCap(world, from.m_6630_(height), to.m_6630_(height), CuboidSide.CEILING, posConsumer);
            if (!result2.isSuccess()) {
                this.setLastResult(result2);
                return null;
            }
            this.setLastResult(MultiblockResult.SUCCESS);
        } else {
            this.setLastResult(heightResult);
        }
        BlockPos minPos = this.hasFloor ? from.m_7495_() : from;
        BlockPos maxPos = to.m_6630_(this.hasCeiling ? height : height - 1);
        return this.create(minPos, maxPos, (Set<BlockPos>)extraBlocks.build());
    }

    protected BlockPos getOuterPos(Level world, BlockPos pos, Direction direction, int limit) {
        for (int i = 0; i < limit && world.m_46749_(pos) && this.isInnerBlock(world, pos); ++i) {
            pos = pos.m_142300_(direction);
        }
        return pos;
    }

    protected MultiblockResult detectCap(Level world, BlockPos from, BlockPos to, CuboidSide side, Consumer<Collection<BlockPos>> consumer) {
        int x;
        if (!world.m_46832_(from, to)) {
            return NOT_LOADED;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int height = from.m_123342_();
        if (this.hasFrame) {
            Predicate<BlockPos> frameCheck = pos -> this.isValidBlock(world, (BlockPos)pos, side, true);
            Component frameError = side == CuboidSide.CEILING ? INVALID_CEILING_FRAME : INVALID_FLOOR_FRAME;
            for (x = from.m_123341_(); x <= to.m_123341_(); ++x) {
                if (!frameCheck.test((BlockPos)mutable.m_122178_(x, height, from.m_123343_()))) {
                    return MultiblockResult.error(mutable.m_7949_(), frameError);
                }
                if (frameCheck.test((BlockPos)mutable.m_122178_(x, height, to.m_123343_()))) continue;
                return MultiblockResult.error(mutable.m_7949_(), frameError);
            }
            for (int z = from.m_123343_() + 1; z < to.m_123343_(); ++z) {
                if (!frameCheck.test((BlockPos)mutable.m_122178_(from.m_123341_(), height, z))) {
                    return MultiblockResult.error(mutable.m_7949_(), frameError);
                }
                if (frameCheck.test((BlockPos)mutable.m_122178_(to.m_123341_(), height, z))) continue;
                return MultiblockResult.error(mutable.m_7949_(), frameError);
            }
        }
        Component blockError = side == CuboidSide.CEILING ? INVALID_CEILING_BLOCK : INVALID_FLOOR_BLOCK;
        for (int z = from.m_123343_() + 1; z < to.m_123343_(); ++z) {
            for (x = from.m_123341_() + 1; x < to.m_123341_(); ++x) {
                if (this.isValidBlock(world, (BlockPos)mutable.m_122178_(x, height, z), side, false)) continue;
                return MultiblockResult.error(mutable.m_7949_(), blockError);
            }
        }
        return MultiblockResult.SUCCESS;
    }

    protected MultiblockResult detectLayer(Level world, BlockPos from, BlockPos to, Consumer<Collection<BlockPos>> consumer) {
        int z;
        if (!world.m_46832_(from, to)) {
            return NOT_LOADED;
        }
        ArrayList candidates = Lists.newArrayList();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int height = from.m_123342_();
        if (this.hasFrame) {
            Predicate<BlockPos> frameCheck = pos -> this.isValidBlock(world, (BlockPos)pos, CuboidSide.WALL, true);
            if (!frameCheck.test(from)) {
                return MultiblockResult.error(from.m_7949_(), INVALID_WALL_FRAME);
            }
            if (!frameCheck.test((BlockPos)mutable.m_122178_(from.m_123341_(), height, to.m_123343_()))) {
                return MultiblockResult.error(mutable.m_7949_(), INVALID_WALL_FRAME);
            }
            if (!frameCheck.test((BlockPos)mutable.m_122178_(to.m_123341_(), height, from.m_123343_()))) {
                return MultiblockResult.error(mutable.m_7949_(), INVALID_WALL_FRAME);
            }
            if (!frameCheck.test(to)) {
                return MultiblockResult.error(to.m_7949_(), INVALID_WALL_FRAME);
            }
        }
        for (int x = from.m_123341_() + 1; x < to.m_123341_(); ++x) {
            for (z = from.m_123343_() + 1; z < to.m_123343_(); ++z) {
                mutable.m_122178_(x, height, z);
                if (this.isInnerBlock(world, (BlockPos)mutable)) {
                    if (world.m_46859_((BlockPos)mutable)) continue;
                    candidates.add(mutable.m_7949_());
                    continue;
                }
                return MultiblockResult.error(mutable.m_7949_(), INVALID_INNER_BLOCK);
            }
        }
        Predicate<BlockPos> wallCheck = pos -> this.isValidBlock(world, (BlockPos)pos, CuboidSide.WALL, false);
        for (int x = from.m_123341_() + 1; x < to.m_123341_(); ++x) {
            if (!wallCheck.test((BlockPos)mutable.m_122178_(x, height, from.m_123343_()))) {
                return MultiblockResult.error(mutable.m_7949_(), INVALID_WALL_BLOCK);
            }
            if (wallCheck.test((BlockPos)mutable.m_122178_(x, height, to.m_123343_()))) continue;
            return MultiblockResult.error(mutable.m_7949_(), INVALID_WALL_BLOCK);
        }
        for (z = from.m_123343_() + 1; z < to.m_123343_(); ++z) {
            if (!wallCheck.test((BlockPos)mutable.m_122178_(from.m_123341_(), height, z))) {
                return MultiblockResult.error(mutable.m_7949_(), INVALID_WALL_BLOCK);
            }
            if (wallCheck.test((BlockPos)mutable.m_122178_(to.m_123341_(), height, z))) continue;
            return MultiblockResult.error(mutable.m_7949_(), INVALID_WALL_BLOCK);
        }
        consumer.accept(candidates);
        return MultiblockResult.SUCCESS;
    }

    protected abstract boolean isValidBlock(Level var1, BlockPos var2, CuboidSide var3, boolean var4);

    public boolean isInnerBlock(Level world, BlockPos pos) {
        return world.m_46859_(pos);
    }

    public abstract boolean shouldUpdate(Level var1, MultiblockStructureData var2, BlockPos var3, BlockState var4);

    @Nullable
    public T readFromTag(CompoundTag nbt) {
        BlockPos minPos = TagUtil.readPos(nbt, "min");
        BlockPos maxPos = TagUtil.readPos(nbt, "max");
        if (minPos == null || maxPos == null) {
            return null;
        }
        ImmutableSet extra = ImmutableSet.copyOf(MultiblockCuboid.readPosList(nbt, "extra"));
        return this.create(minPos, maxPos, (Set<BlockPos>)extra);
    }

    public abstract T create(BlockPos var1, BlockPos var2, Set<BlockPos> var3);

    protected static Collection<BlockPos> readPosList(CompoundTag rootTag, String key) {
        List<BlockPos> collection;
        if (rootTag.m_128425_(key, 9)) {
            ListTag list = rootTag.m_128437_(key, 10);
            collection = new ArrayList<BlockPos>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                BlockPos pos = TagUtil.readPos(list.m_128728_(i));
                if (pos == null) continue;
                collection.add(pos);
            }
        } else {
            collection = Collections.emptyList();
        }
        return collection;
    }

    public MultiblockCuboid(boolean hasFloor, boolean hasFrame, boolean hasCeiling, int maxHeight, int innerLimit) {
        this.hasFloor = hasFloor;
        this.hasFrame = hasFrame;
        this.hasCeiling = hasCeiling;
        this.maxHeight = maxHeight;
        this.innerLimit = innerLimit;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    protected void setLastResult(MultiblockResult lastResult) {
        this.lastResult = lastResult;
    }

    public MultiblockResult getLastResult() {
        return this.lastResult;
    }

    public static enum CuboidSide {
        FLOOR,
        CEILING,
        WALL;

    }
}

