/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.module.alloying;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.level.Level;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipe;
import slimeknights.tconstruct.library.recipe.alloying.IMutableAlloyTank;
import slimeknights.tconstruct.smeltery.block.entity.module.alloying.IAlloyingModule;

public class SingleAlloyingModule
implements IAlloyingModule {
    private final MantleBlockEntity parent;
    private final IMutableAlloyTank alloyTank;
    private AlloyRecipe lastRecipe;

    private Level getLevel() {
        return Objects.requireNonNull(this.parent.m_58904_(), "Parent tile entity has null world");
    }

    @Nullable
    private AlloyRecipe findRecipe() {
        Level world = this.getLevel();
        if (this.lastRecipe != null && this.lastRecipe.canPerform(this.alloyTank)) {
            return this.lastRecipe;
        }
        Optional<AlloyRecipe> recipe = world.m_7465_().m_44054_(RecipeTypes.ALLOYING).values().stream().filter(r -> r instanceof AlloyRecipe).map(r -> (AlloyRecipe)r).filter(r -> this.alloyTank.canFit(r.getOutput(), 0) && r.canPerform(this.alloyTank)).findAny();
        if (recipe.isPresent()) {
            this.lastRecipe = recipe.get();
            return this.lastRecipe;
        }
        return null;
    }

    @Override
    public boolean canAlloy() {
        return this.findRecipe() != null;
    }

    @Override
    public void doAlloy() {
        AlloyRecipe recipe = this.findRecipe();
        if (recipe != null) {
            recipe.performRecipe(this.alloyTank);
        }
    }

    public SingleAlloyingModule(MantleBlockEntity parent, IMutableAlloyTank alloyTank) {
        this.parent = parent;
        this.alloyTank = alloyTank;
    }
}

