/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.argument;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.TranslatableComponent;
import slimeknights.tconstruct.library.tools.SlotType;

public class SlotTypeArgument
implements ArgumentType<OptionalSlotType> {
    private static final Collection<String> EXAMPLES = Arrays.asList("upgrades", "abilities");
    private static final DynamicCommandExceptionType SLOT_TYPE_NOT_FOUND = new DynamicCommandExceptionType(name -> new TranslatableComponent("command.tconstruct.slot_type.not_found", new Object[]{name}));
    private final boolean allowSlotless;

    public static SlotTypeArgument slotType() {
        return SlotTypeArgument.slotType(true);
    }

    public static OptionalSlotType getOptional(CommandContext<CommandSourceStack> context, String name) {
        return (OptionalSlotType)context.getArgument(name, OptionalSlotType.class);
    }

    public static SlotType getSlotType(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        SlotType slot = SlotTypeArgument.getOptional(context, name).slotType();
        if (slot == null) {
            throw SLOT_TYPE_NOT_FOUND.create((Object)"slotless");
        }
        return slot;
    }

    public OptionalSlotType parse(StringReader reader) throws CommandSyntaxException {
        String name = reader.readString();
        if (this.allowSlotless && name.equals("slotless")) {
            return new OptionalSlotType(null);
        }
        SlotType type = SlotType.getIfPresent(name);
        if (type != null) {
            return new OptionalSlotType(type);
        }
        throw SLOT_TYPE_NOT_FOUND.createWithContext((ImmutableStringReader)reader, (Object)name);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Stream<String> stream = SlotType.getAllSlotTypes().stream().map(SlotType::getName);
        if (this.allowSlotless) {
            stream = Stream.concat(stream, Stream.of("slotless"));
        }
        return SharedSuggestionProvider.m_82981_(stream, (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private SlotTypeArgument(boolean allowSlotless) {
        this.allowSlotless = allowSlotless;
    }

    public static SlotTypeArgument slotType(boolean allowSlotless) {
        return new SlotTypeArgument(allowSlotless);
    }

    public record OptionalSlotType(@Nullable SlotType slotType) {
    }
}

