/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.partbuilder;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Arrays;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.ResourceColorManager;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.recipe.partbuilder.IDisplayPartBuilderRecipe;
import slimeknights.tconstruct.plugin.jei.JEIPlugin;
import slimeknights.tconstruct.plugin.jei.TConstructRecipeCategoryUid;
import slimeknights.tconstruct.plugin.jei.partbuilder.MaterialItemList;
import slimeknights.tconstruct.tables.TinkerTables;

public class PartBuilderCategory
implements IRecipeCategory<IDisplayPartBuilderRecipe> {
    private static final ResourceLocation BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/tinker_station.png");
    private static final Component TITLE = TConstruct.makeTranslation("jei", "part_builder.title");
    private static final String KEY_COST = TConstruct.makeTranslationKey("jei", "part_builder.cost");
    private final IDrawable background;
    private final IDrawable icon;

    public PartBuilderCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(BACKGROUND_LOC, 0, 117, 121, 46);
        this.icon = helper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack(TinkerTables.partBuilder));
    }

    public ResourceLocation getUid() {
        return TConstructRecipeCategoryUid.partBuilder;
    }

    public Class<? extends IDisplayPartBuilderRecipe> getRecipeClass() {
        return IDisplayPartBuilderRecipe.class;
    }

    public Component getTitle() {
        return TITLE;
    }

    public void setIngredients(IDisplayPartBuilderRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, Arrays.asList(MaterialItemList.getItems(recipe.getMaterial().getVariant()), recipe.getPatternItems()));
        ingredients.setInput(JEIPlugin.PATTERN_TYPE, (Object)recipe.getPattern());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
    }

    public void draw(IDisplayPartBuilderRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        Component name = MaterialTooltipCache.getColoredDisplayName(recipe.getMaterial().getVariant());
        fontRenderer.m_92750_(matrixStack, name.getString(), 3.0f, 2.0f, Objects.requireNonNullElse(name.m_7383_().m_131135_(), ResourceColorManager.WHITE).m_131265_());
        String coolingString = I18n.m_118938_((String)KEY_COST, (Object[])new Object[]{recipe.getCost()});
        fontRenderer.m_92883_(matrixStack, coolingString, 3.0f, 35.0f, Color.GRAY.getRGB());
    }

    public void setRecipe(IRecipeLayout layout, IDisplayPartBuilderRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup items = layout.getItemStacks();
        items.init(0, true, 24, 15);
        items.init(1, true, 3, 15);
        items.init(2, false, 95, 14);
        items.set(ingredients);
        IGuiIngredientGroup patterns = layout.getIngredientsGroup(JEIPlugin.PATTERN_TYPE);
        patterns.init(0, true, 46, 16);
        patterns.set(ingredients);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

