/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.melting;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.fluid.FluidTooltipHandler;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.plugin.jei.AlloyRecipeCategory;
import slimeknights.tconstruct.plugin.jei.TConstructRecipeCategoryUid;
import slimeknights.tconstruct.plugin.jei.melting.AbstractMeltingCategory;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class FoundryCategory
extends AbstractMeltingCategory {
    private static final Component TITLE = TConstruct.makeTranslation("jei", "foundry.title");
    private static final ITooltipCallback<FluidStack> METAL_ORE_TOOLTIP = new MeltingFluidCallback(IMeltingContainer.OreRateType.METAL);
    private static final ITooltipCallback<FluidStack> GEM_ORE_TOOLTIP = new MeltingFluidCallback(IMeltingContainer.OreRateType.GEM);
    private final IDrawable icon;

    public FoundryCategory(IGuiHelper helper) {
        super(helper);
        this.icon = helper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack(TinkerSmeltery.foundryController));
    }

    public ResourceLocation getUid() {
        return TConstructRecipeCategoryUid.foundry;
    }

    public Component getTitle() {
        return TITLE;
    }

    @Override
    public void setIngredients(MeltingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.m_7527_());
        ingredients.setOutputLists(VanillaTypes.FLUID, recipe.getOutputWithByproducts());
    }

    public void setRecipe(IRecipeLayout layout, MeltingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup items = layout.getItemStacks();
        items.init(0, true, 23, 17);
        items.set(ingredients);
        IGuiFluidStackGroup fluids = layout.getFluidStacks();
        AlloyRecipeCategory.drawVariableFluids(fluids, 0, false, 96, 4, 32, 32, recipe.getOutputWithByproducts(), 810);
        fluids.set(ingredients);
        fluids.init(-1, true, 4, 4, 12, 32, 1, false, null);
        fluids.set(-1, MeltingFuelHandler.getUsableFuels(recipe.getTemperature()));
        IMeltingContainer.OreRateType oreType = recipe.getOreType();
        if (oreType == IMeltingContainer.OreRateType.METAL) {
            fluids.addTooltipCallback(METAL_ORE_TOOLTIP);
        } else if (oreType == IMeltingContainer.OreRateType.GEM) {
            fluids.addTooltipCallback(GEM_ORE_TOOLTIP);
        } else {
            fluids.addTooltipCallback((ITooltipCallback)MeltingFluidCallback.INSTANCE);
        }
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    private static class MeltingFluidCallback
    extends AbstractMeltingCategory.MeltingFluidCallback {
        private final IMeltingContainer.OreRateType oreRate;

        @Override
        protected boolean appendMaterial(FluidStack stack, List<Component> list) {
            return FluidTooltipHandler.appendMaterialNoShift(stack.getFluid(), Config.COMMON.foundryOreRate.applyOreBoost(this.oreRate, stack.getAmount()), list);
        }

        public MeltingFluidCallback(IMeltingContainer.OreRateType oreRate) {
            this.oreRate = oreRate;
        }

        public IMeltingContainer.OreRateType getOreRate() {
            return this.oreRate;
        }
    }
}

