/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.melting;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.fluid.FluidTooltipHandler;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;

public abstract class AbstractMeltingCategory
implements IRecipeCategory<MeltingRecipe> {
    protected static final ResourceLocation BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/melting.png");
    protected static final String KEY_COOLING_TIME = TConstruct.makeTranslationKey("jei", "melting.time");
    protected static final String KEY_TEMPERATURE = TConstruct.makeTranslationKey("jei", "temperature");
    protected static final String KEY_MULTIPLIER = TConstruct.makeTranslationKey("jei", "melting.multiplier");
    protected static final Component TOOLTIP_ORE = new TranslatableComponent(TConstruct.makeTranslationKey("jei", "melting.ore"));
    private final IDrawable background;
    protected final IDrawableStatic tankOverlay;
    protected final IDrawableStatic plus;
    protected final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public AbstractMeltingCategory(final IGuiHelper helper) {
        this.background = helper.createDrawable(BACKGROUND_LOC, 0, 0, 132, 40);
        this.tankOverlay = helper.createDrawable(BACKGROUND_LOC, 132, 0, 32, 32);
        this.plus = helper.drawableBuilder(BACKGROUND_LOC, 132, 34, 6, 6).build();
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer meltingTime) {
                return helper.drawableBuilder(BACKGROUND_LOC, 150, 41, 24, 17).buildAnimated(meltingTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public Class<? extends MeltingRecipe> getRecipeClass() {
        return MeltingRecipe.class;
    }

    public void setIngredients(MeltingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.m_7527_());
        ingredients.setOutputLists(VanillaTypes.FLUID, recipe.getDisplayOutput());
    }

    public void draw(MeltingRecipe recipe, PoseStack matrices, double mouseX, double mouseY) {
        ((IDrawableAnimated)this.cachedArrows.getUnchecked((Object)(recipe.getTime() * 5))).draw(matrices, 56, 18);
        if (recipe.getOreType() != null) {
            this.plus.draw(matrices, 87, 31);
        }
        int temperature = recipe.getTemperature();
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        String tempString = I18n.m_118938_((String)KEY_TEMPERATURE, (Object[])new Object[]{temperature});
        int x = 56 - fontRenderer.m_92895_(tempString) / 2;
        fontRenderer.m_92883_(matrices, tempString, (float)x, 3.0f, Color.GRAY.getRGB());
    }

    public List<Component> getTooltipStrings(MeltingRecipe recipe, double mouseXD, double mouseYD) {
        int mouseX = (int)mouseXD;
        int mouseY = (int)mouseYD;
        if (recipe.getOreType() != null && GuiUtil.isHovered(mouseX, mouseY, 87, 31, 16, 16)) {
            return Collections.singletonList(TOOLTIP_ORE);
        }
        if (GuiUtil.isHovered(mouseX, mouseY, 56, 18, 24, 17)) {
            return Collections.singletonList(new TranslatableComponent(KEY_COOLING_TIME, new Object[]{recipe.getTime() / 4}));
        }
        return Collections.emptyList();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public static class MeltingFluidCallback
    implements ITooltipCallback<FluidStack> {
        public static final MeltingFluidCallback INSTANCE = new MeltingFluidCallback();

        protected boolean appendMaterial(FluidStack stack, List<Component> list) {
            return FluidTooltipHandler.appendMaterialNoShift(stack.getFluid(), stack.getAmount(), list);
        }

        public void onTooltip(int index, boolean input, FluidStack stack, List<Component> list) {
            Component name = list.get(0);
            Component modId = list.get(list.size() - 1);
            list.clear();
            list.add(name);
            if (index != -1) {
                if (index == 0) {
                    if (this.appendMaterial(stack, list)) {
                        FluidTooltipHandler.appendShift(list);
                    }
                } else {
                    FluidTooltipHandler.appendMaterial(stack, list);
                }
            }
            if (index == -1) {
                MeltingFuelHandler.getTemperature(stack.getFluid()).ifPresent(temperature -> {
                    list.add((Component)new TranslatableComponent(KEY_TEMPERATURE, new Object[]{temperature}).m_130940_(ChatFormatting.GRAY));
                    list.add((Component)new TranslatableComponent(KEY_MULTIPLIER, new Object[]{Float.valueOf((float)temperature / 1000.0f)}).m_130940_(ChatFormatting.GRAY));
                });
            }
            list.add(modId);
        }
    }
}

