/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.fluid.FluidTooltipHandler;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe;
import slimeknights.tconstruct.plugin.jei.JEIPlugin;
import slimeknights.tconstruct.plugin.jei.TConstructRecipeCategoryUid;
import slimeknights.tconstruct.plugin.jei.entity.EntityIngredientHelper;
import slimeknights.tconstruct.plugin.jei.entity.EntityIngredientRenderer;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;

public class EntityMeltingRecipeCategory
implements IRecipeCategory<EntityMeltingRecipe> {
    public static final ResourceLocation BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/melting.png");
    private static final Component TITLE = TConstruct.makeTranslation("jei", "entity_melting.title");
    private static final String KEY_PER_HEARTS = TConstruct.makeTranslationKey("jei", "entity_melting.per_hearts");
    private static final Component TOOLTIP_PER_HEART = new TranslatableComponent(TConstruct.makeTranslationKey("jei", "entity_melting.per_heart")).m_130940_(ChatFormatting.GRAY);
    private static final Int2ObjectMap<ITooltipCallback<FluidStack>> TOOLTIP_MAP = new Int2ObjectOpenHashMap();
    private final EntityIngredientRenderer entityRenderer = new EntityIngredientRenderer(32);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable arrow;
    private final IDrawable tank;

    public EntityMeltingRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(BACKGROUND_LOC, 0, 41, 150, 62);
        this.icon = helper.createDrawable(BACKGROUND_LOC, 174, 41, 16, 16);
        this.arrow = helper.drawableBuilder(BACKGROUND_LOC, 150, 41, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.tank = helper.createDrawable(BACKGROUND_LOC, 150, 74, 16, 16);
    }

    public ResourceLocation getUid() {
        return TConstructRecipeCategoryUid.entityMelting;
    }

    public Class<? extends EntityMeltingRecipe> getRecipeClass() {
        return EntityMeltingRecipe.class;
    }

    public Component getTitle() {
        return TITLE;
    }

    public static List<List<ItemStack>> getSpawnEggs(Stream<EntityType<?>> entities) {
        return ImmutableList.of(entities.map(ForgeSpawnEggItem::fromEntityType).filter(Objects::nonNull).map(ItemStack::new).collect(Collectors.toList()));
    }

    public void setIngredients(EntityMeltingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(JEIPlugin.ENTITY_TYPE, recipe.getDisplayInputs());
        ingredients.setInputLists(VanillaTypes.ITEM, EntityMeltingRecipeCategory.getSpawnEggs(recipe.getInputs().stream()));
        ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getOutput());
    }

    public void draw(EntityMeltingRecipe recipe, PoseStack matrices, double mouseX, double mouseY) {
        this.arrow.draw(matrices, 71, 21);
        String damage = Float.toString((float)recipe.getDamage() / 2.0f);
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int x = 84 - fontRenderer.m_92895_(damage);
        fontRenderer.m_92883_(matrices, damage, (float)x, 8.0f, Color.RED.getRGB());
    }

    public void setRecipe(IRecipeLayout layout, EntityMeltingRecipe recipe, IIngredients ingredients) {
        IGuiIngredientGroup entityTypes = layout.getIngredientsGroup(JEIPlugin.ENTITY_TYPE);
        entityTypes.init(0, true, (IIngredientRenderer)this.entityRenderer, 19, 11, 32, 32, 0, 0);
        entityTypes.set(ingredients);
        EntityIngredientHelper.setFocus(layout, (IGuiIngredientGroup<EntityType>)entityTypes, recipe.getInputs(), 0);
        IGuiFluidStackGroup fluids = layout.getFluidStacks();
        fluids.addTooltipCallback((ITooltipCallback)TOOLTIP_MAP.computeIfAbsent(recipe.getDamage(), FluidTooltip::new));
        fluids.init(1, false, 115, 11, 16, 32, 180, false, null);
        fluids.set(ingredients);
        fluids.init(2, true, 75, 43, 16, 16, 1, false, this.tank);
        fluids.set(2, MeltingFuelHandler.getUsableFuels(1));
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    private record FluidTooltip(int damage) implements ITooltipCallback<FluidStack>
    {
        public void onTooltip(int index, boolean input, FluidStack fluid, List<Component> list) {
            Component name = list.get(0);
            Component modId = list.get(list.size() - 1);
            list.clear();
            list.add(name);
            if (index != 2) {
                FluidTooltipHandler.appendMaterial(fluid, list);
            }
            if (index == 1) {
                if (this.damage == 2) {
                    list.add(TOOLTIP_PER_HEART);
                } else {
                    list.add((Component)new TranslatableComponent(KEY_PER_HEARTS, new Object[]{Float.valueOf((float)this.damage / 2.0f)}).m_130940_(ChatFormatting.GRAY));
                }
            }
            list.add(modId);
        }
    }
}

