/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.entity;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.recipe.ingredient.EntityIngredient;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe;
import slimeknights.tconstruct.smeltery.block.entity.module.EntityMeltingModule;

public class DefaultEntityMeltingRecipe
extends EntityMeltingRecipe {
    private final Lazy<List<EntityType<?>>> entityList = Lazy.of(() -> DefaultEntityMeltingRecipe.getEntityList(recipes));

    private static List<EntityType<?>> getEntityList(List<EntityMeltingRecipe> recipes) {
        ArrayList<EntityType> unusedTypes = new ArrayList<EntityType>();
        block0: for (EntityType type : ForgeRegistries.ENTITIES) {
            if (TinkerTags.EntityTypes.MELTING_HIDE.m_8110_((Object)type) || type.m_20674_() == MobCategory.MISC && !TinkerTags.EntityTypes.MELTING_SHOW.m_8110_((Object)type)) continue;
            for (EntityMeltingRecipe recipe : recipes) {
                if (!recipe.matches(type)) continue;
                continue block0;
            }
            unusedTypes.add(type);
        }
        return ImmutableList.copyOf(unusedTypes);
    }

    public DefaultEntityMeltingRecipe(List<EntityMeltingRecipe> recipes) {
        super(TConstruct.getResource("__default"), EntityIngredient.EMPTY, EntityMeltingModule.getDefaultFluid(), 2);
    }

    @Override
    public Collection<EntityType<?>> getInputs() {
        return (Collection)this.entityList.get();
    }
}

