/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.molding.MoldingRecipe;
import slimeknights.tconstruct.plugin.jei.TConstructRecipeCategoryUid;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MoldingRecipeCategory
implements IRecipeCategory<MoldingRecipe> {
    private static final ResourceLocation BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/casting.png");
    private static final Component TITLE = TConstruct.makeTranslation("jei", "molding.title");
    private static final Component TOOLTIP_PATTERN_CONSUMED = new TranslatableComponent(TConstruct.makeTranslationKey("jei", "molding.pattern_consumed"));
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable table;
    private final IDrawable basin;
    private final IDrawable downArrow;
    private final IDrawable upArrow;

    public MoldingRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(BACKGROUND_LOC, 0, 55, 70, 57);
        this.icon = helper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)TinkerSmeltery.blankSandCast.get()));
        this.table = helper.createDrawable(BACKGROUND_LOC, 117, 0, 16, 16);
        this.basin = helper.createDrawable(BACKGROUND_LOC, 117, 16, 16, 16);
        this.downArrow = helper.createDrawable(BACKGROUND_LOC, 70, 55, 6, 6);
        this.upArrow = helper.createDrawable(BACKGROUND_LOC, 76, 55, 6, 6);
    }

    public ResourceLocation getUid() {
        return TConstructRecipeCategoryUid.molding;
    }

    public Class<? extends MoldingRecipe> getRecipeClass() {
        return MoldingRecipe.class;
    }

    public Component getTitle() {
        return TITLE;
    }

    public void draw(MoldingRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        IDrawable block = recipe.m_6671_() == RecipeTypes.MOLDING_BASIN ? this.basin : this.table;
        block.draw(matrixStack, 3, 40);
        if (!recipe.getPattern().m_43947_()) {
            block.draw(matrixStack, 51, 40);
            this.downArrow.draw(matrixStack, 8, 17);
        } else {
            this.upArrow.draw(matrixStack, 8, 17);
        }
    }

    public List<Component> getTooltipStrings(MoldingRecipe recipe, double mouseX, double mouseY) {
        if (recipe.isPatternConsumed() && !recipe.getPattern().m_43947_() && GuiUtil.isHovered((int)mouseX, (int)mouseY, 50, 7, 18, 18)) {
            return Collections.singletonList(TOOLTIP_PATTERN_CONSUMED);
        }
        return Collections.emptyList();
    }

    public void setIngredients(MoldingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.m_7527_());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
    }

    public void setRecipe(IRecipeLayout layout, MoldingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        guiItemStacks.init(0, true, 2, 23);
        guiItemStacks.init(1, false, 50, 23);
        if (!recipe.getPattern().m_43947_()) {
            guiItemStacks.init(2, true, 2, 0);
            guiItemStacks.set(ingredients);
            if (!recipe.isPatternConsumed()) {
                guiItemStacks.init(3, true, 50, 7);
                guiItemStacks.set(3, (List)ingredients.getInputs(VanillaTypes.ITEM).get(1));
            }
        } else {
            guiItemStacks.set(ingredients);
        }
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

