/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;

public class JsonUtils {
    private JsonUtils() {
    }

    public static int getIntMin(JsonObject json, String key, int min) {
        int value = GsonHelper.m_13824_((JsonObject)json, (String)key, (int)min);
        if (value < min) {
            throw new JsonSyntaxException(key + " must be at least " + min);
        }
        return value;
    }

    public static int getIntMin(JsonElement json, String key, int min) {
        int value = GsonHelper.m_13897_((JsonElement)json, (String)key);
        if (value < min) {
            throw new JsonSyntaxException(key + " must be at least " + min);
        }
        return value;
    }

    public static <T extends IForgeRegistryEntry<T>> T convertToEntry(IForgeRegistry<T> registry, JsonElement element, String key) {
        IForgeRegistryEntry value;
        ResourceLocation name = JsonHelper.convertToResourceLocation((JsonElement)element, (String)key);
        if (registry.containsKey(name) && (value = registry.getValue(name)) != null) {
            return (T)value;
        }
        throw new JsonSyntaxException("Unknown " + registry.getRegistryName() + " " + name);
    }

    public static <T extends IForgeRegistryEntry<T>> T getAsEntry(IForgeRegistry<T> registry, JsonObject parent, String key) {
        return JsonUtils.convertToEntry(registry, JsonHelper.getElement((JsonObject)parent, (String)key), key);
    }

    @Nullable
    public static JsonObject getJson(Resource resource) {
        JsonObject jsonObject;
        BufferedReader reader = new BufferedReader(new InputStreamReader(resource.m_6679_(), StandardCharsets.UTF_8));
        try {
            jsonObject = GsonHelper.m_13859_((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonParseException | IOException e) {
                TConstruct.LOG.error("Failed to load JSON from resource " + resource.m_7843_(), e);
                return null;
            }
        }
        reader.close();
        return jsonObject;
    }

    public static List<JsonObject> getFileInAllDomainsAndPacks(ResourceManager manager, String path) {
        return manager.m_7187_().stream().filter(ResourceLocation::m_135843_).flatMap(namespace -> {
            ResourceLocation location = new ResourceLocation(namespace, path);
            try {
                return manager.m_7396_(location).stream();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException e) {
                TConstruct.LOG.error("Failed to load JSON files from {}", (Object)location, (Object)e);
            }
            return Stream.empty();
        }).map(JsonUtils::getJson).filter(Objects::nonNull).toList();
    }
}

